package com.najva.sdk.in_app_messaging.view;

import androidx.annotation.Nullable;

import java.io.Serializable;

public enum InAppType implements Serializable {
    FULL_SCREEN(0),
    CARD(1),
    HEADER(2),
    FOOTER(3),
    MODAL(4),
    IMAGE_ONLY(5);
    private int i;

    InAppType(int i) {
        this.i = i;
    }

    public int getType() {
        return i;
    }
    @Nullable
    public static InAppType getInAppType(int type){
        for(InAppType inAppType:InAppType.values()){
            if(inAppType.getType() == type)
                return inAppType;
        }
        return null;
    }
}
