package com.najva.sdk.in_app_messaging.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.najva.sdk.in_app_messaging.model.InApp;
import com.najva.sdk.in_app_messaging.database.InAppSchema.InAppTable.InAppColumn;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class InAppRepository {

    private static InAppRepository instance;
    private SQLiteDatabase inAppDb;
    private InAppCursorWrapper cursorWrapper;


    public static InAppRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InAppRepository(context);
        }
        return instance;
    }

    private InAppRepository(Context context) {
        inAppDb = new InAppOpenHelper(context).getWritableDatabase();
    }

     void insertInApp(InApp inApp) {
        ContentValues values = getContentValues(inApp);
        inAppDb.insert(InAppSchema.InAppTable.NAME
                , null
                , values);
    }

    private ContentValues getContentValues(InApp inApp) {
        ContentValues values = new ContentValues();
        values.put(InAppColumn.UUID, inApp.getId().toString());
        values.put(InAppColumn.TYPE, inApp.getType().getType());
        values.put(InAppColumn.COLOR, inApp.getBackgroundColor());
        values.put(InAppColumn.END_DATE,inApp.getEndDate().getTime());
        values.put(InAppColumn.SHOW_IN_LOW_CONNECTION,inApp.isShowInLowConnection());
        values.put(InAppColumn.DELAY,inApp.getDelay());

        values.put(InAppColumn.TITLE, inApp.getTitle().getText());
        values.put(InAppColumn.TITLE_VISIBILITY, inApp.getTitle().isVisibility() );
        values.put(InAppColumn.TITLE_COLOR, inApp.getTitle().getColor());
        values.put(InAppColumn.TITLE_AVAILABLE,inApp.getTitle().isAvailable());

        values.put(InAppColumn.DESCRIPTION, inApp.getDescription().getText());
        values.put(InAppColumn.DESCRIPTION_VISIBILITY, inApp.getDescription().isVisibility());
        values.put(InAppColumn.DESCRIPTION_COLOR, inApp.getDescription().getColor());
        values.put(InAppColumn.DESCRIPTION_AVAILABLE,inApp.getDescription().isAvailable());

        values.put(InAppColumn.PRIMARY_BTN_TEXT, inApp.getButtonPrimary().getText());
        values.put(InAppColumn.PRIMARY_BTN_VISIBILITY, inApp.getButtonPrimary().isVisibility());
        values.put(InAppColumn.PRIMARY_BTN_TEXT_COLOR, inApp.getButtonPrimary().getTextColor());
        values.put(InAppColumn.PRIMARY_BTN_BACKGROUND_COLOR, inApp.getButtonPrimary().getBackgroundColor());
        values.put(InAppColumn.PRIMARY_BTN_ACTION, inApp.getButtonPrimary().getAction());
        values.put(InAppColumn.PRIMARY_BTN_AVAILABLE,inApp.getButtonPrimary().isAvailable());

        values.put(InAppColumn.SECONDARY_BTN_TEXT, inApp.getButtonSecondary().getText());
        values.put(InAppColumn.SECONDARY_BTN_VISIBILITY, inApp.getButtonSecondary().isVisibility());
        values.put(InAppColumn.SECONDARY_BTN_TEXT_COLOR, inApp.getButtonSecondary().getTextColor());
        values.put(InAppColumn.SECONDARY_BTN_BACKGROUND_COLOR, inApp.getButtonSecondary().getBackgroundColor());
        values.put(InAppColumn.SECONDARY_BTN_ACTION, inApp.getButtonSecondary().getAction());
        values.put(InAppColumn.SECONDARY_BTN_AVAILABLE,inApp.getButtonSecondary().isAvailable());

        values.put(InAppColumn.IMAGE_URL, inApp.getImage().getImageUrl());
        values.put(InAppColumn.IMAGE_ACTION, inApp.getImage().getAction());
        values.put(InAppColumn.IMAGE_VISIBILITY, inApp.getImage().isVisibility());

        values.put(InAppColumn.CLOSE_BTN_TYPE,inApp.getCloseButton().getType().toString());
        values.put(InAppColumn.CLOSE_BTN_COLOR,inApp.getCloseButton().getColor());

        Log.d("Repository", "getContentValues: " + values.get(InAppColumn.IMAGE_VISIBILITY));

        return values;
    }

    public void deleteInApp(UUID uuid) {
        inAppDb.delete(InAppSchema.InAppTable.NAME
                , InAppColumn.UUID + " = ? "
                , new String[]{uuid.toString()});
    }
    void deleteAllInApp(){
        inAppDb.delete(InAppSchema.InAppTable.NAME,null,null);
    }

    List<InApp> getInApp() {
        List<InApp> inAppList = new ArrayList<>();
        Cursor cursor = inAppDb.query(InAppSchema.InAppTable.NAME,
                null,
                null,
                null,
                null,
                null,
                null);
        cursorWrapper = new InAppCursorWrapper(cursor);

        try {
            if (!cursorWrapper.moveToFirst())
                return null;
            while (!cursorWrapper.isAfterLast()) {
                Log.d("Repository", "getInApp: " );
                inAppList.add(cursorWrapper.getInApp());
                cursorWrapper.moveToNext();
            }
        } finally {
            cursorWrapper.close();
        }
        return inAppList;
    }
}
