package com.najva.sdk.in_app_messaging.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import androidx.annotation.Nullable;

import com.najva.sdk.in_app_messaging.database.InAppSchema.InAppTable.InAppColumn;


public class InAppOpenHelper extends SQLiteOpenHelper {
    InAppOpenHelper(@Nullable Context context) {
        super(context, InAppSchema.NAME, null, InAppSchema.VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table " + InAppSchema.InAppTable.NAME + " ( "
                + "_id integer primary key autoincrement, "
                + InAppColumn.UUID + ", "
                + InAppColumn.TYPE + ", "
                + InAppColumn.COLOR + ", "
                + InAppColumn.END_DATE + ", "
                + InAppColumn.SHOW_IN_LOW_CONNECTION + ", "
                + InAppColumn.DELAY + ", "
                + InAppColumn.TITLE + ", "
                + InAppColumn.TITLE_COLOR + ", "
                + InAppColumn.TITLE_VISIBILITY + ", "
                + InAppColumn.TITLE_AVAILABLE + ", "
                + InAppColumn.DESCRIPTION + ", "
                + InAppColumn.DESCRIPTION_COLOR + ", "
                + InAppColumn.DESCRIPTION_VISIBILITY + ", "
                + InAppColumn.DESCRIPTION_AVAILABLE + ", "
                + InAppColumn.PRIMARY_BTN_TEXT + ", "
                + InAppColumn.PRIMARY_BTN_TEXT_COLOR + ", "
                + InAppColumn.PRIMARY_BTN_BACKGROUND_COLOR + ", "
                + InAppColumn.PRIMARY_BTN_VISIBILITY + ", "
                + InAppColumn.PRIMARY_BTN_ACTION + ", "
                + InAppColumn.PRIMARY_BTN_AVAILABLE + ", "
                + InAppColumn.SECONDARY_BTN_TEXT + ", "
                + InAppColumn.SECONDARY_BTN_TEXT_COLOR + ", "
                + InAppColumn.SECONDARY_BTN_BACKGROUND_COLOR + ", "
                + InAppColumn.SECONDARY_BTN_VISIBILITY + ", "
                + InAppColumn.SECONDARY_BTN_ACTION + ", "
                + InAppColumn.SECONDARY_BTN_AVAILABLE + ", "
                + InAppColumn.IMAGE_URL + ", "
                + InAppColumn.IMAGE_ACTION + ", "
                + InAppColumn.IMAGE_VISIBILITY + ","
                + InAppColumn.CLOSE_BTN_TYPE + ","
                + InAppColumn.CLOSE_BTN_COLOR
                + " ) "
        );
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }
}
