package com.najva.sdk.core;

import androidx.annotation.NonNull;

import java.util.UUID;

public class SessionManager {
    private static SessionManager instance;

    private static final long NEW_SESSION_CRITIERA = 30 * 60 * 1000; //half an hour.
    @NonNull
    public static SessionManager getInstance() {
        if (instance == null) instance = new SessionManager();
        return instance;
    }

    public static String getSession() {
        return getInstance().getSessionToken();
    }

    private UUID token;

    private long lastUsageTime = 0;

    private SessionManager(){
        updateSession();
    }

    private String getSessionToken(){
        updateSessionIfNeeded();
        return token.toString();
    }

    public void onStop(){
        lastUsageTime = System.currentTimeMillis();
    }

    public void onStart(){
        updateSessionIfNeeded();
        lastUsageTime = 0;
    }

    private void updateSessionIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (lastUsageTime == 0) return;
        long lastActivityDelay = lastUsageTime - currentTime;
        if (lastActivityDelay>=NEW_SESSION_CRITIERA){
            updateSession();
        }
    }

    private void updateSession() {
        token = UUID.randomUUID();
    }
}
