package com.najva.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

public class DeleteNotificationReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent == null) return;
        int notificationId = intent.getIntExtra(StaticFields.NOTIFICATION_ID,0);

        OneTimeWorkRequest request = new FormRequestWorker.Builder(context)
                .addParam(StaticFields.NOTIFICATION_ID,String.valueOf(notificationId))
                .addParam(StaticFields.WEBSITE_ID, String.valueOf(ClientMetaData.getWebsiteId()))
                .addParam(StaticFields.API_KEY,ClientMetaData.getApiKey(context))
                .setMethod(Request.Method.POST)
                .setUrl(ApiInfo.DELETE_NOTIFICATION.getValue())
                .build();
        WorkManager.getInstance(context).enqueue(request);
    }
}
