package com.najva.sdk.push_notification.handlers;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.widget.ImageView;

import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;


import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ImageRequest;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.utils.VolleySingleton;

import java.util.Map;

public class IconNotificationHandler extends NormalNotificationHandler {
    public IconNotificationHandler(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }

    private void displayIconNotification() {
        ImageRequest imageRequest = new ImageRequest(data.get(StaticFields.ICON), new Response.Listener<Bitmap>() {
            @Override
            public void onResponse(Bitmap response) {
                if (response != null) {
                    builder.setLargeIcon(response);

                    sendNotification();
                }
            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });

        VolleySingleton.getInstance(context).add(imageRequest);
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public void updateBuilder(Notification.Builder builder) {
        builder.setAutoCancel(true);
        setNotificationSmallIcon(builder);

        builder.setColorized(true);
        builder.setColor(ContextCompat.getColor(context, R.color.najva));
        builder.setLights(ContextCompat.getColor(context, R.color.najva), 500, 500);

        builder.setContentTitle(data.get(StaticFields.TITLE));
        builder.setContentText(data.get(StaticFields.BODY));

        displayIconNotification();
    }

}
