package com.najva.sdk.push_notification;

import android.content.Context;
import android.os.Build;

import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.push_notification.handlers.BigTextNotificationHandler;
import com.najva.sdk.push_notification.handlers.IconNotificationHandler;
import com.najva.sdk.push_notification.handlers.ImageNotificationHandler;
import com.najva.sdk.push_notification.handlers.NormalNotificationHandler;
import com.najva.sdk.push_notification.handlers.compat.BigTextNotificationHandlerCompat;
import com.najva.sdk.push_notification.handlers.compat.IconNotificationHandlerCompat;
import com.najva.sdk.push_notification.handlers.compat.ImageNotificationHandlerCompat;
import com.najva.sdk.push_notification.handlers.compat.NormalNotificationHandlerCompat;

import java.util.Map;

public class NotificationHandler {
    public static void handle(Context context, Map<String,String> data,String messageId,NotificationUtils utils){
        final String notificationType = data.get(StaticFields.NOTIFICATION_TYPE);

        boolean useCompat = Build.VERSION.SDK_INT < Build.VERSION_CODES.O;

        if (NotificationType.NORMAL.equalsIgnoreCase(notificationType)){
            if (useCompat) {
                new NormalNotificationHandlerCompat(context, data, messageId).showNotification();
            } else {
                new NormalNotificationHandler(context, data, messageId).showNotification();
            }
        } else if (NotificationType.BIG_TEXT.equalsIgnoreCase(notificationType)){
            if (useCompat){
                new BigTextNotificationHandlerCompat(context,data,messageId).showNotification();
            } else {
                new BigTextNotificationHandler(context,data,messageId).showNotification();
            }

        } else if (NotificationType.ICON.equalsIgnoreCase(notificationType)){
            if (useCompat){
                new IconNotificationHandlerCompat(context,data,messageId).showNotification();
            } else {
                new IconNotificationHandler(context,data,messageId).showNotification();
            }

        } else if (NotificationType.BIG_PICTURE.equalsIgnoreCase(notificationType)){
            if (useCompat){
                new ImageNotificationHandlerCompat(context,data,messageId).showNotification();
            } else {
                new ImageNotificationHandler(context,data,messageId).showNotification();
            }

        } else if (NotificationType.RATING.equalsIgnoreCase(notificationType)){
            //TODO no implemented yet :)
        } else { // in case that server is old.
            utils.showNotification(context.getApplicationContext(), data, messageId);
        }
    }
}
