package com.najva.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.app.AppVersionController;
import com.najva.sdk.app.AppVersionControllerImpl;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

public class PackageReplaceReceiver extends BroadcastReceiver {
    public static final String TAG = "PackageReplaceReceiver";
    String version;

    @Override
    public void onReceive(final Context context, Intent intent) {
        Log.i(TAG, "onReceive: ");


        PackageInfo pInfo = null;
        try {
            pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        version = pInfo.versionName;
        Log.d(TAG, "load: " + version);
        final OneTimeWorkRequest worker = new FormRequestWorker.Builder(context)
                .setUrl(ApiInfo.UPDATE_OPERATOR.getValue())
                .setMethod(Request.Method.POST)
                .addParam(StaticFields.ServerParameter.APP_VERSION, version)
                .build();
        WorkManager.getInstance().enqueue(worker);

    }
}
