package com.najva.sdk.push_notification;

import android.content.Context;
import android.support.annotation.NonNull;

import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaImpl;
import com.najva.sdk.campaign.CampaignController;
import com.najva.sdk.campaign.CampaignControllerImpl;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.location.LocationControllerImpl;
import com.najva.sdk.remote_config.RemoteConfigControllerImpl;

/**
 * created for initialize FirebaseApp
 */

public class PushNotificationControllerImpl extends Thread implements PushNotificationController {

    private final Context context;
    private final String apiKey;
    private final int websiteId;

    public PushNotificationControllerImpl(@NonNull Context context, @NonNull String apiKey,int websiteId) {
        this.context = context;
        this.apiKey = apiKey;
        this.websiteId = websiteId;
    }

    @Override
    public void load() {
        FirebaseOptions options = new FirebaseOptions.Builder()
                .setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()) // Required for Analytics.
                .setApiKey(Parameter.FIREBASE_API_KEY.getValue()) // Required for Auth.
                .setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()) // Required for RTDB.
                .build();
        try {
            FirebaseApp.getInstance();
            FirebaseApp.initializeApp(context, options, this.apiKey);
        } catch (Exception ignored) {
            FirebaseApp.initializeApp(context, options);
            StaticFields.DefaultParameter.NAJVA_IS_DEFAULT = true;
        }

        registerIfNeeded(context);

    }

    private void registerIfNeeded(Context context) {
        //checking if firebase token is available
        String firebaseToken = FirebaseInstanceId.getInstance(getFireBaseInstance(context)).getToken();
        if (firebaseToken == null) return;
        //checking in najva token in not null
        String najvaToken = Najva.getSubscribedToken(context);
        if (najvaToken!= null) return;

        // firebase token is available and najva token is not so we must register device

        ClientMetaData.setApiKey(context,this.apiKey);
        ClientMetaData.setToken(firebaseToken);
        ClientMetaData.setWebsiteId(websiteId);
        CampaignController campaignController = new CampaignControllerImpl(context,
                new LocationControllerImpl(context),
                new RemoteConfigControllerImpl(context),
                ClientMetaData.getParams());
        campaignController.loadAsync();
    }

    private FirebaseApp getFireBaseInstance(Context context) {
        if (StaticFields.DefaultParameter.NAJVA_IS_DEFAULT){
            return FirebaseApp.getInstance();
        } else {
            return FirebaseApp.getInstance(this.apiKey);
        }
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }
}
