package com.najva.sdk.core.utils;

import android.support.annotation.Nullable;

import androidx.work.ListenableWorker;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkError;
import com.android.volley.ParseError;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;

public class VolleyErrorHandler {
    public static ListenableWorker.Result handleError(@Nullable VolleyError error) {

        if (error == null || error.networkResponse == null) {
            return ListenableWorker.Result.failure();
        }

        if (error instanceof NetworkError) {
            return ListenableWorker.Result.retry();
        } else if (error instanceof ServerError) {
            return ListenableWorker.Result.failure();
        } else if (error instanceof AuthFailureError) {
            return ListenableWorker.Result.failure();
        } else if (error instanceof ParseError) {
            return ListenableWorker.Result.failure();
        } else if (error instanceof TimeoutError) {
            return ListenableWorker.Result.retry();
        }


        // errors that cant be fixed with retry
        switch (error.networkResponse.statusCode) {
            case 500:
            case 501:
            case 503:
            case 400:
            case 401:
            case 403:
            case 404:
            case 405:
            case 415:
                return ListenableWorker.Result.failure();

        }
        return ListenableWorker.Result.failure();
    }
}
