package com.najva.sdk.core.utils;

import android.support.annotation.Nullable;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.toolbox.RequestFuture;
import com.android.volley.toolbox.StringRequest;

import java.util.HashMap;
import java.util.Map;

public class MetaRequest extends StringRequest {
    private static final String TAG = "MetaRequest";
    private static final String SET_COOKIE = "Set-Cookie";
    private CookieManager cookieManager;
    private Map<String, String> params = new HashMap<>();
    private Map<String, String> headers = new HashMap<>();
    private RequestFuture<String> future;

    MetaRequest(int method, String url, Response.Listener<String> listener, @Nullable Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
        LogDetails(url);
    }

    private void LogDetails(String url) {
        Log.d(TAG, "url: " + url);
    }


    void setCookieManager(CookieManager manager) {
        this.cookieManager = manager;
    }

    private CookieManager getCookieManager() {
        return cookieManager;
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {

        handleNetworkResponse(response);

        return super.parseNetworkResponse(response);
    }

    private void handleNetworkResponse(NetworkResponse response) {
        Map<String, String> headers = response.headers;
        try {
            String cookies = headers.get(SET_COOKIE);
            updateCookies(cookies);
        } catch (Exception ignored) {
        }

        for (com.android.volley.Header h : response.allHeaders) {
            if (h.getName().equalsIgnoreCase(SET_COOKIE)) {
                getCookieManager().saveCookie(h.getValue());
            }
        }

        Log.d(TAG,"response: " + new String(response.data));
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {

        if (cookieManager == null) return super.getHeaders();

        headers.put(StaticFields.ServerParameter.COOKIE, cookieManager.getCookies());
        Log.d(TAG, headers.toString());
        return headers;
    }



    @Override
    public Map<String, String> getParams() {
        Log.d(TAG, params.toString());
        return params;
    }

    void addHeader(String key, String value) {
        headers.put(key, value);
    }

    void addPostParams(String key, String value) {
        params.put(key, value);
    }

    private void updateCookies(String cookies) {
        if (cookieManager != null)
            cookieManager.saveCookie(cookies);
    }

    void setFuture(RequestFuture<String> future) {
        this.future = future;
    }

    public RequestFuture<String> getFuture() {
        return future;
    }
}
