package com.najva.sdk.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;

import com.najva.sdk.Najva;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class Utility {
    private Utility() {
    }

    public static String getDeviceModel() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    public static String getAndroidId(@NonNull Context context) {
        @SuppressLint("HardwareIds") String androidId = Settings.Secure.getString(context.getContentResolver(),
                Settings.Secure.ANDROID_ID);
        return androidId;
    }


    public static String getSimOperatorName(@NonNull Context context) {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    public static String getAndroidVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    public static String getPackageInfo(@NonNull Context context) {
        JSONArray jsonResponse = new JSONArray();
        PackageManager packageManager = context.getPackageManager();
        List<ApplicationInfo> installedApplications =
                packageManager.getInstalledApplications(PackageManager.GET_META_DATA);

        int sysAppOrUpdated = ApplicationInfo.FLAG_SYSTEM;

        for (ApplicationInfo appInfo : installedApplications) {
            if ((appInfo.flags & sysAppOrUpdated) != 0) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(StaticFields.ServerParameter.PACKAGE_NAME, appInfo.packageName);
                    jsonObject.put(StaticFields.ServerParameter.APP_LABEL, appInfo.loadLabel(packageManager));
                    jsonResponse.put(jsonObject);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }
        }
        return jsonResponse.toString();

    }

    public static String getAppVersion(@NonNull Context context) {
        String version = "";
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = pInfo.versionName;
            System.out.println(version == null);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static boolean isSubscribed(@NonNull Context context) {
        return Najva.getSubscribedToken(context) != null;
    }

    public static boolean isTokenChanged(Context context, String token) {
        String lastToken = FileManager.readFromFile(context, Parameter.FIREBASE_TOKEN.getValue());
        return lastToken == null || !lastToken.trim().equals(token.trim());
    }

    public static void setToken(Context context, String token) {
        FileManager.writeToFile(context,  Parameter.FIREBASE_TOKEN.getValue(), token);
    }
}
