package com.najva.sdk.push_notification.service;

import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.sdk.push_notification.NajvaPushNotificationHandler;


/**
 * Created by sina on 9/16/2018.
 */
public class NajvaMessagingService extends FirebaseMessagingService {
    public static final String TAG = "NajvaMessagingService";

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        if (remoteMessage == null) return;
        Log.d(TAG, "new notification received");
        NajvaPushNotificationHandler.handleMessage(getApplicationContext(), remoteMessage);
    }

    @Override
    public void onNewToken(String s) {
        super.onNewToken(s);
        Log.d(TAG, "onNewToken: " + s);
        NajvaPushNotificationHandler.handleNewToken(getApplicationContext());
    }
}
