package com.najva.sdk.push_notification;

import android.content.Context;
import android.support.annotation.NonNull;

import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;

/**
 * created for initialize FirebaseApp
 */

public class PushNotificationControllerImpl extends Thread implements PushNotificationController {

    private final Context context;
    private final String apiKey;

    public PushNotificationControllerImpl(@NonNull Context context, @NonNull String apiKey) {
        this.context = context;
        this.apiKey = apiKey;
    }

    @Override
    public void load() {
        FirebaseOptions options = new FirebaseOptions.Builder()
                .setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()) // Required for Analytics.
                .setApiKey(Parameter.FIREBASE_API_KEY.getValue()) // Required for Auth.
                .setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()) // Required for RTDB.
                .build();
        try {
            FirebaseApp.getInstance();
            FirebaseApp.initializeApp(context, options, this.apiKey);
        } catch (Exception ignored) {
            FirebaseApp.initializeApp(context, options);
            StaticFields.DefaultParameter.NAJVA_IS_DEFAULT = true;
        }


    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }
}
