package com.najva.sdk.push_notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.widget.ImageView;

import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ImageRequest;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.Najva;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.utils.VolleySingleton;
import com.najva.sdk.push_notification.service.NajvaNotificationIntentService;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class NotificationUtils {
    private static final String TAG = "NotificationUtils";
    public static NotificationUtils getInstance() {
        return new NotificationUtils();
    }



    private PendingIntent setNotificationAction(@NonNull Context context,
                                                @NonNull String notificationAction,
                                                int notificationId,
                                                @NonNull String finalAddress,
                                                @NonNull String notificationContent,
                                                @NonNull String messageId,
                                                @NonNull String clickType,
                                                int button_id) {

        //replaced with old reflection code
        Intent notificationIntent = NajvaNotificationIntentService.newIntent(context,
                notificationAction,
                notificationId,
                getWebsiteInfo(context),
                finalAddress,
                notificationContent,
                messageId,
                clickType,
                button_id);

        // generate random integer for pending intent unique
        int dummyUniqueInt = new Random().nextInt(543254);
        return PendingIntent.getService(context, dummyUniqueInt, notificationIntent, PendingIntent.FLAG_ONE_SHOT);

    }

    private ArrayList<String> getWebsiteInfo(@NonNull Context context) {
        ArrayList<String> records = new ArrayList<>();
        records.add(String.valueOf(ClientMetaData.getWebsiteId()));
        records.add(ClientMetaData.getApiKey(context));
        return records;

    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    public void createNotificationChannel(@NonNull Context context,
                                          @NonNull String priority,
                                          @NonNull Notification.Builder notificationBuilder) {
        NotificationManager mNotificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        String channelId = context.getString(R.string.default_notification_channel_id);

        int notificationPriority = NotificationManager.IMPORTANCE_DEFAULT;
        if (priority.equalsIgnoreCase(StaticFields.DataParameter.NOTIFICATION_PRIORITY_HIGH)) {
            notificationPriority = NotificationManager.IMPORTANCE_HIGH;
        }

        NotificationChannel channel = new NotificationChannel(channelId, StaticFields.DataParameter.TITLE, notificationPriority);
        channel.setDescription(StaticFields.DataParameter.BODY);
        assert mNotificationManager != null;
        mNotificationManager.createNotificationChannel(channel);
        notificationBuilder.setChannelId(channelId);
    }

    public boolean isOreoPlus() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.O;
    }

    void showNotification(@NonNull final Context context,@NonNull final Map<String, String> data,
                          @NonNull final String messageId) {
        final String notificationId = data.get(StaticFields.DataParameter.NOTIFICATION_ID);
        final String finalAddress = data.get(StaticFields.DataParameter.URL);
        final String onClickAction = data.get(StaticFields.DataParameter.ONCLICK_ACTION);
        String notificationContent = data.get(StaticFields.DataParameter.NOTIFICATION_CONTENT);
        final String priority = data.get(StaticFields.DataParameter.PRIORITY);


        if (notificationContent == null) {
            notificationContent = StaticFields.BLANK;
        }

        assert onClickAction != null;
        assert notificationId != null;
        assert finalAddress != null;
        final PendingIntent pendingIntent = setNotificationAction(
                context,
                onClickAction,
                Integer.parseInt(notificationId),
                finalAddress,
                notificationContent,
                messageId,
                Parameter.ORIGINAL_CLICK_TYPE.getValue(),
                -1
        );


        final Notification.Builder notificationBuilder = getNotificationBuilderFactory()
                .newNotificationBuilder(context);
        notificationBuilder
                .setContentTitle(data.get(StaticFields.DataParameter.TITLE))
                .setContentText(data.get(StaticFields.DataParameter.BODY))
                .setAutoCancel(true);

        // Since android Oreo notification channel is needed.
        if (isOreoPlus()) {
            assert priority != null;
            createNotificationChannel(context, priority, notificationBuilder);
        } else {
            updatePriorityUnderOreo(notificationBuilder, priority);
        }


        if (pendingIntent != null) {
            notificationBuilder.setContentIntent(pendingIntent);
        }


        String canLightUp = data.get(StaticFields.DataParameter.LIGHT_UP_SCREEN);

        if (canLightUp != null && canLightUp.equalsIgnoreCase("true")) {
            wakeUpDevice(context);
        }

        String btn1Enabled = data.get(StaticFields.DataParameter.BTN1_ENABLED);

        if (btn1Enabled != null && btn1Enabled.equalsIgnoreCase("true") && isMPlus()) {
            addButton1(context, data, notificationId, messageId, notificationBuilder);
        }

        String btn2Enabled = data.get(StaticFields.DataParameter.BTN2_ENABLED);

        if (btn2Enabled != null && btn2Enabled.equalsIgnoreCase("true") && isMPlus()) {
            addButton2(context, data, notificationId, messageId, notificationBuilder);
        }

        String icon  = data.get(StaticFields.DataParameter.ICON);
        String image = data.get(StaticFields.DataParameter.IMAGE);

        if (icon == null) {
            if (image != null) {
                downloadImageAndSendNotification(context, notificationBuilder, image,
                        data.get(StaticFields.DataParameter.TITLE),
                        data.get(StaticFields.DataParameter.BODY),
                        messageId);
            } else {
                sendNotification(context, notificationBuilder, messageId);
            }
        } else {
            if (image == null) {
                downloadIconAndSendNotification(context, notificationBuilder, icon, messageId);

            } else {
                downloadIconAndImageAndSendNotification(context, notificationBuilder, data, messageId);
            }
        }
    }

    private void downloadIconAndImageAndSendNotification(@NonNull final Context context,
                                                         @NonNull final Notification.Builder notificationBuilder,
                                                         @NonNull final Map<String, String> data,
                                                         @NonNull final String messageId) {
        ImageRequest imageRequest = new ImageRequest(data.get(StaticFields.DataParameter.ICON), new Response.Listener<Bitmap>() {
            public void onResponse(final Bitmap iconResponse) {

                if (iconResponse != null) {

                    notificationBuilder.setLargeIcon(iconResponse);
                    downloadImageAndSendNotification(context, notificationBuilder, data.get(StaticFields.DataParameter.IMAGE)
                            , data.get(StaticFields.DataParameter.TITLE)
                            , data.get(StaticFields.DataParameter.BODY)
                            , messageId);

                }

            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });
        VolleySingleton.getInstance(context).add(imageRequest);
    }

    private void downloadIconAndSendNotification(@NonNull final Context context,
                                                 @NonNull final Notification.Builder notificationBuilder,
                                                 @NonNull String icon,
                                                 @NonNull final String messageId) {
        ImageRequest imageRequest = new ImageRequest(icon, new Response.Listener<Bitmap>() {
            public void onResponse(Bitmap response) {

                if (response != null) {
                    notificationBuilder.setLargeIcon(response);

                    sendNotification(context, notificationBuilder, messageId);

                }

            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });

        VolleySingleton.getInstance(context).add(imageRequest);
    }

    public void sendNotification(@NonNull Context context, @NonNull Notification.Builder notificationBuilder,
                                 @NonNull String messageId) {
        notificationBuilder.setSmallIcon(R.drawable.notif_icon);
        notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
        notificationBuilder.setLights(Color.BLUE, 1000, 300);

        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        assert notificationManager != null;

        if (Build.VERSION.SDK_INT < 16) {
            notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
        } else {
            notificationManager.notify(messageId, 0, notificationBuilder.build());
        }
    }

    private void downloadImageAndSendNotification(@NonNull final Context context,
                                                  @NonNull final Notification.Builder notificationBuilder,
                                                  @NonNull String imageUrl,
                                                  @NonNull final String title,
                                                  @NonNull final String body,
                                                  @NonNull final String messageId) {
        ImageRequest imageRequest = new ImageRequest(imageUrl, new Response.Listener<Bitmap>() {
            public void onResponse(Bitmap response) {

                if (response != null && Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {

                    Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle()
                            .bigPicture(response)
                            .setBigContentTitle(title)
                            .setSummaryText(body);

                    notificationBuilder.setStyle(bigPictureStyle);

                    sendNotification(context, notificationBuilder, messageId);
                }

            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });
        VolleySingleton.getInstance(context).add(imageRequest);
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    public void addButton2(@NonNull Context context, @NonNull Map<String, String> data,
                           @NonNull String notificationId,
                           @NonNull String messageId,
                           @NonNull Notification.Builder notificationBuilder) {
        String btn2Title ;
        String btn2Action ;
        String btn2FinalAddress ;
        String btn2Content ;
        int btn2Icon = 0;
        int btn2Id = 0;
        btn2Title = data.get(StaticFields.DataParameter.BTN2_TITLE);

        if (btn2Title == null) {
            btn2Title = StaticFields.BLANK;
        }

        String iconTemp = data.get(StaticFields.DataParameter.BTN2_ICON);

        if (iconTemp != null) {
            int iconCode = 0;
            try {
                iconCode = Integer.valueOf(iconTemp);
            } catch (Exception ignored) {
            }

            btn2Icon = IconHandler.getNotificationButtonIcon(iconCode);
        }

        String bid = data.get(StaticFields.DataParameter.BTN2_ID);

        if (bid != null) {
            btn2Id = Integer.valueOf(bid);
        }

        btn2Action = data.get(StaticFields.DataParameter.BTN2_ACTION);

        if (btn2Action == null) {
            btn2Action = StaticFields.DataParameter.BUTTON_ACTION_CLOSE;
        }

        btn2FinalAddress = data.get(StaticFields.DataParameter.BTN2_ADDRESS);

        if (btn2FinalAddress == null) {
            btn2Action = StaticFields.BLANK;
        }

        btn2Content = data.get(StaticFields.DataParameter.BTN2_CONTENT);

        if (btn2Content == null) {
            btn2Content = StaticFields.BLANK;
        }

        assert btn2FinalAddress != null;
        PendingIntent buttonPendingIntent = setNotificationAction(
                context,
                btn2Action,
                Integer.parseInt(notificationId),
                btn2FinalAddress,
                btn2Content,
                messageId,
                Parameter.BUTTON_CLICK_TYPE.getValue(),
                btn2Id
        );

        notificationBuilder.addAction(btn2Icon, btn2Title, buttonPendingIntent);
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    public void addButton1(@NonNull Context context, @NonNull Map<String, String> data,
                           @NonNull String notificationId,
                           @NonNull String messageId,
                           @NonNull Notification.Builder notificationBuilder) {
        String btn1Title ;
        String btn1Action ;
        String btn1FinalAddress ;
        String btn1Content ;
        int btn1Icon = 0;
        int btn1Id = 0;
        btn1Title = data.get(StaticFields.DataParameter.BTN1_TITLE);

        if (btn1Title == null) {
            btn1Title = StaticFields.BLANK;
        }

        String iconTemp = data.get(StaticFields.DataParameter.BTN1_ICON);

        if (iconTemp != null) {
            int iconCode = 0;
            try {
                iconCode = Integer.valueOf(iconTemp);
            } catch (Exception ignored) {
            }

            btn1Icon = IconHandler.getNotificationButtonIcon(iconCode);
        }

        String bid = data.get(StaticFields.DataParameter.BTN1_ID);

        if (bid != null) {
            btn1Id = Integer.valueOf(bid);
        }

        btn1Action = data.get(StaticFields.DataParameter.BTN1_ACTION);

        if (btn1Action == null) {
            btn1Action = StaticFields.DataParameter.BUTTON_ACTION_CLOSE;
        }

        btn1FinalAddress = data.get(StaticFields.DataParameter.BTN1_ADDRESS);

        if (btn1FinalAddress == null) {
            btn1Action = StaticFields.BLANK;
        }

        btn1Content = data.get(StaticFields.DataParameter.BTN1_CONTENT);

        if (btn1Content == null) {
            btn1Content = StaticFields.BLANK;
        }

        assert btn1FinalAddress != null;
        PendingIntent buttonPendingIntent = setNotificationAction(
                context,
                btn1Action,
                Integer.parseInt(notificationId),
                btn1FinalAddress,
                btn1Content,
                messageId,
                Parameter.BUTTON_CLICK_TYPE.getValue(),
                btn1Id
        );

        notificationBuilder.addAction(btn1Icon, btn1Title, buttonPendingIntent);
    }

    private boolean isScreenOn(@NonNull Context context) {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        return pm.isScreenOn();
    }

    private void wakeUpDevice(@NonNull Context context) {
        if (!isScreenOn(context)) {
            wakeUp(context);
        }
    }

    private void wakeUp(@NonNull Context context) {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);

        PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, "najva::wakelog");
        wl.acquire(10000);
        PowerManager.WakeLock wl_cpu = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "najva::wakelog");

        wl_cpu.acquire(10000);
    }

    private void updatePriorityUnderOreo(@NonNull Notification.Builder notificationBuilder,
                                         @Nullable String priority) {
        if (priority != null && Build.VERSION.SDK_INT >= 16) {
            if (priority.equalsIgnoreCase(StaticFields.DataParameter.NOTIFICATION_PRIORITY_HIGH)) {
                notificationBuilder.setPriority(Notification.PRIORITY_HIGH);
            } else if (priority.equalsIgnoreCase(StaticFields.DataParameter.NOTIFICATION_PRIORITY_LOW)) {
                notificationBuilder.setPriority(Notification.PRIORITY_LOW);
            }
        }
    }

    public NotificationBuilderFactory getNotificationBuilderFactory() {
        return new NotificationBuilderFactory();
    }

    public boolean isNajvaMessage(@NonNull Context context,@NonNull RemoteMessage remoteMessage) {
        boolean result = false;
        Map<String, String> data = remoteMessage.getData();
        if (data != null) {
            String apiKey = data.get(StaticFields.DataParameter.API_KEY);
            String localApiKey = ClientMetaData.getApiKey(context);

            if (localApiKey == null) {
                Log.e(TAG, "You must call Najva.initialize() before using isNajvaMessage method");
                result = false;
            } else if (apiKey == null) {
                Log.e(TAG, "Provide api_key from message is null, contact support!");
                result = false;
            } else {
                result = apiKey.equals(localApiKey);
                if (!result) {
                    Log.e(TAG, "Provide api_key from message is not equal to localApiKey.");
                }
            }
        }

        return result;
    }

    public boolean isMPlus() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.M;
    }
    public static void broadcastNajvaClick(Context context,String messageId, int buttonId) {
        Intent intent = new Intent(Najva.ACTION_CLICK_RECEIVED);
        intent.putExtra(StaticFields.DataParameter.MESSAGE_ID,messageId);
        intent.putExtra(StaticFields.DataParameter.BUTTON_ID,buttonId);
        context.sendBroadcast(intent);
    }

    public void broadcastNajvaNotification(Context context,RemoteMessage remoteMessage) {
        Intent intent = new Intent(Najva.ACTION_NOTIFICATION_RECEIVED);
        intent.putExtra(StaticFields.DataParameter.MESSAGE_ID,remoteMessage.getMessageId());
        intent.putExtra(StaticFields.DataParameter.NOTIFICATION_TAG,remoteMessage.getData().get(StaticFields.DataParameter.NOTIFICATION_TAG));
        context.sendBroadcast(intent);
        Log.d(TAG, "broadcastNajvaNotification: " + intent.toString());
    }
}
