package com.najva.sdk.push_notification;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;

import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaImpl;
import com.najva.sdk.campaign.CampaignController;
import com.najva.sdk.campaign.CampaignControllerImpl;
import com.najva.sdk.core.utils.JsonFile;
import com.najva.sdk.core.utils.NotificationActionHandler;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.location.LocationControllerImpl;
import com.najva.sdk.remote_config.RemoteConfigControllerImpl;


import java.util.Map;

public class NajvaPushNotificationHandler {
    private static final String TAG = "NajvaPushNotifHandler";

    public static void handleMessage(@NonNull final Context context, @NonNull RemoteMessage remoteMessage) {
        NotificationUtils notificationUtils = NotificationUtils.getInstance();
        sendNotification(context, remoteMessage, notificationUtils);
    }

    // for better testing no item should be initialized during test so we have to take them as parameters
    private static void sendNotification(@NonNull final Context context, @NonNull RemoteMessage remoteMessage,
                                         @NonNull NotificationUtils notificationUtils) {
        String messageId = remoteMessage.getMessageId();
        Map<String, String> data = remoteMessage.getData();
        Log.d(TAG, "new notification received");

        if (notificationUtils.isNajvaMessage(context, remoteMessage)) {
            String notificationType = getNotificationType(data.get(StaticFields.DataParameter.NOTIFICATION_TYPE));
            if (notificationType.equals(StaticFields.DefaultParameter.JSON_DATA)) {

                final String jsonData = data.get(StaticFields.DataParameter.JSON_DATA);
                Log.d(TAG, "sendNotification>>>jsonData: " + jsonData);
                if (jsonData != null && !jsonData.isEmpty()) {
                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        public void run() {
                            if (!NajvaImpl.deliverJsonData(jsonData)) {
                                JsonFile.getInstance().writeAsJson(context, jsonData);
                            }
                        }
                    });

                }
            } else if (notificationType.equals(StaticFields.DataParameter.DATA_CONFIG)) {
                //sdk config
                Log.d(TAG, "sendNotification>>>sdk config: ");
                 NotificationActionHandler.handleNajvaConfig(context, data,messageId);
            } else {

                assert messageId != null;
                Log.d(TAG, "sendNotification>>>simpleNotification: " + data.toString());

                notificationUtils.showNotification(context.getApplicationContext(), data, messageId);
                notificationUtils.broadcastNajvaNotification(context,remoteMessage);
            }

        }
    }

    private static String getNotificationType(String type) {
        return type != null ? type : StaticFields.DefaultParameter.NOTIFICATION_TYPE;
    }

    public static void handleNewToken(@NonNull Context context) {
        String najvaTokenInFirebase;
        if (StaticFields.DefaultParameter.NAJVA_IS_DEFAULT)
            najvaTokenInFirebase = FirebaseInstanceId.getInstance(FirebaseApp.getInstance()).getToken();
        else
            najvaTokenInFirebase = FirebaseInstanceId.getInstance(FirebaseApp.getInstance(ClientMetaData.getApiKey(context))).getToken();


        Log.d(TAG, "handleNewToken: "+StaticFields.DefaultParameter.NAJVA_IS_DEFAULT+" , " + najvaTokenInFirebase);

        ClientMetaData.setToken(najvaTokenInFirebase);
        CampaignController campaignController = new CampaignControllerImpl(
                context,
                new LocationControllerImpl(context),
                new RemoteConfigControllerImpl(context),
                ClientMetaData.getParams()
        );
        campaignController.load();
    }

    public static boolean isNajvaMessage(@NonNull Context context,RemoteMessage remoteMessage){
        return NotificationUtils.getInstance().isNajvaMessage(context,remoteMessage);
    }


}
