package com.najva.sdk.location;


import android.content.Context;

import android.support.annotation.NonNull;
import android.util.Log;


import androidx.work.ExistingPeriodicWorkPolicy;

import androidx.work.PeriodicWorkRequest;

import androidx.work.WorkManager;


import com.najva.sdk.core.Utility;

import com.najva.sdk.core.utils.Configuration;
import com.najva.sdk.core.utils.StaticFields;

import com.najva.sdk.core.works.LocationRequestWorker;

/**
 * Create a periodic work
 * to fetch location params and POST to server.
 */

public class LocationControllerImpl extends Thread implements LocationController {
    private final Context context;
    private static final String TAG = "LocationControllerImpl";


    public LocationControllerImpl(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void load() {
        this.setLocationRequest();
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }

    private void setLocationRequest() {
        if (!Utility.isSubscribed(context)) {
            return;
        }

        Log.d(TAG, "user subscribed");
        PeriodicWorkRequest locationRequest = new LocationRequestWorker.Builder()
                .setRepeatInterval(Configuration.readInterval(context))
                .build();
        WorkManager.getInstance().enqueueUniquePeriodicWork(
                StaticFields.DefaultParameter.LOCATION_UNIQUE_WORK,
                ExistingPeriodicWorkPolicy.KEEP,
                locationRequest);

    }

}
