package com.najva.sdk.core.utils;


import android.content.Context;
import android.support.annotation.NonNull;



public class Configuration {


    public static long readInterval(@NonNull Context context) {
        String interval = FileManager.readFromFile(context, Parameter.NAJVA_CONFIGURATION_FILE_NAME.getValue());
        try {
            return Long.parseLong(interval);
        } catch (Exception e) {
            return StaticFields.DefaultParameter.REPEAT_INTERVAL;
        }
    }

    static void writeInterval(@NonNull Context context, long repeatInterval) {
        FileManager.writeToFile(context, Parameter.NAJVA_CONFIGURATION_FILE_NAME.getValue(), String.valueOf(repeatInterval));
    }

}
