package com.najva.sdk.campaign;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaImpl;
import com.najva.sdk.core.Utility;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;
import com.najva.sdk.location.LocationController;
import com.najva.sdk.remote_config.RemoteConfigController;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

/**
 * Add subscriber to campaign, POST device parameter to server
 */

public class CampaignControllerImpl extends Thread implements CampaignController {
    private final Context context;
    private final LocationController locationController;
    private RemoteConfigController configController;
    private final HashMap<String, String> params;
    private final String RESPONSE_COOKIE = "cookie_token";
    private final String RESPONSE_KEY = "response";
    public static final String TAG = "CampaignControllerImpl";


    public CampaignControllerImpl(@NonNull Context context,
                                  @NonNull LocationController locationController,
                                  @NonNull RemoteConfigController configController,
                                  @NonNull HashMap<String, String> params) {
        this.context = context;
        this.locationController = locationController;
        this.configController = configController;
        this.params = params;

    }

    @Override
    public void load() {
        addSubscriberToCampaign(context, params);
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }

    private void addSubscriberToCampaign(final Context context, final HashMap<String,
            String> params) {

        if (Utility.isSubscribed(context) &&
                !Utility.isTokenChanged(context, params.get(StaticFields.ServerParameter.TOKEN))) {
            Log.d(TAG, "addSubscriberToCampaign: " + "already subscribed!");
            return;
        }

        // saving token to check if it has been changed.
        Utility.setToken(context, params.get(StaticFields.ServerParameter.TOKEN));

        final OneTimeWorkRequest worker = new FormRequestWorker.Builder(context)
                .setUrl(ApiInfo.ADD_SUBSCRIBER_URL.getValue())
                .setMethod(Request.Method.POST)
                .setParams(params).build();

        WorkManager.getInstance().enqueue(worker);

        final LiveData<WorkInfo> workInfoLiveData = WorkManager.getInstance()
                .getWorkInfoByIdLiveData(worker.getId());


        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                workInfoLiveData.observeForever(new Observer<WorkInfo>() {
                    @Override
                    public void onChanged(@Nullable WorkInfo workInfo) {
                        if (workInfo == null) return;
                        if (workInfo.getState() == WorkInfo.State.SUCCEEDED) {
                            Log.d(TAG, "add work success");
                            String response = workInfo.getOutputData().getString(RESPONSE_KEY);
                            handleSubscribeToCampaignResponse(response);
                            workInfoLiveData.removeObserver(this);
                        }
                    }
                });
            }
        });

    }

    private void handleSubscribeToCampaignResponse(String response) {
        locationController.load();
        //configController.load();
        // syncing najva user and application user!
        try {
            JSONObject jsonObj = new JSONObject(response);
            String token =  jsonObj.getString(RESPONSE_COOKIE);
            Log.d(TAG, "handleSubscribeToCampaignResponse>>>token: " + token);
            NajvaImpl.deliverUserSubscribed(token);
            FileManager.writeToFile(context,Parameter.TOKEN_FILE_NAME.getValue(),token);

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (NullPointerException ignored) {
        }

        createDeviceInfoRequest(context);
        saveSimOperator(context);
    }


    private void createDeviceInfoRequest(final Context context) {


        OneTimeWorkRequest oneTimeWorkRequest = new FormRequestWorker.Builder(context)
                .setUrl(ApiInfo.CREATE_DEVICE_INFO.getValue())
                .setParams(getDeviceInfoParams(context))
                .setMethod(Request.Method.POST)
                .build();

        WorkManager.getInstance().enqueue(oneTimeWorkRequest);

    }

    private HashMap<String, String> getDeviceInfoParams(Context context) {
        HashMap<String, String> params = new HashMap<>();

        params.put(StaticFields.ServerParameter.SIMCARD_NAME, Utility.getSimOperatorName(context));
        params.put(StaticFields.ServerParameter.DEVICE_MODEL, Utility.getDeviceModel());
        params.put(StaticFields.ServerParameter.ANDROID_VERSION, Utility.getAndroidVersion());
        params.put(StaticFields.ServerParameter.ANDROID_ID, Utility.getAndroidId(context));

        String encodedPackageInfo = Utility.getPackageInfo(context);
        try {
            encodedPackageInfo = URLEncoder.encode(encodedPackageInfo, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put(StaticFields.ServerParameter.ANDROID_PACKAGE_INFO, encodedPackageInfo);
        params.put(StaticFields.ServerParameter.MANUFACTURER, Build.MANUFACTURER);
        params.put(StaticFields.ServerParameter.APP_VERSION, Utility.getAppVersion(context));

        return params;
    }

    private void saveSimOperator(Context context) {
        FileManager.writeToFile(context, Parameter.OPERATOR_NAME_FILE_NAME.getValue(), Utility.getSimOperatorName(context));
    }
}
