package com.najva.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.najva.sdk.app.AppVersionController;
import com.najva.sdk.app.AppVersionControllerImpl;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.JsonFile;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.crash_report.NajvaCrashReporter;
import com.najva.sdk.location.LocationController;
import com.najva.sdk.location.LocationControllerImpl;
import com.najva.sdk.login.LoginController;
import com.najva.sdk.login.LoginControllerImpl;
import com.najva.sdk.push_notification.PushNotificationController;
import com.najva.sdk.push_notification.PushNotificationControllerImpl;
import com.najva.sdk.utils.MetaDataUtils;

import org.json.JSONArray;
import org.json.JSONException;

public class NajvaImpl {
    private static UserSubscriptionListener userSubscriptionListener;
    private static NajvaJsonDataListener najvaJsonDataListener;

    public static void initialize(@NonNull Context context) {

        String apiKey = getApiKey(context);
        int websiteId = getWebSiteId(context);

        ClientMetaData.setWebsiteId(websiteId);
        ClientMetaData.setApiKey(context, apiKey);


        PushNotificationController pushNotificationController = new PushNotificationControllerImpl(context, apiKey);
        pushNotificationController.loadAsync();

        LocationController locationController = new LocationControllerImpl(context);
        locationController.loadAsync();


        AppVersionController appVersionController = new AppVersionControllerImpl(context);
        appVersionController.loadAsync();

        LoginController loginController = new LoginControllerImpl(context, apiKey, websiteId);
        loginController.loadAsync();

        NajvaCrashReporter.getInstance(context).loadAsync();

        /*
        RemoteConfigController configController = new RemoteConfigControllerImpl(context);
        configController.load();
        */

    }

    private static ApplicationInfo getApplicationInfo(@NonNull Context context) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int getWebSiteId(@NonNull Context context) {
        return MetaDataUtils.getInstance(getApplicationInfo(context)).getWebsiteId();
    }

    private static String getApiKey(@NonNull Context context) {
        return MetaDataUtils.getInstance(getApplicationInfo(context)).getApiKey();
    }

    public static void setUserSubscriptionListener(@Nullable UserSubscriptionListener userSubscriptionListener) {
        NajvaImpl.userSubscriptionListener = userSubscriptionListener;
    }

    public static void setNajvaJsonDataListener(@Nullable NajvaJsonDataListener najvaJsonDataListener) {
        NajvaImpl.najvaJsonDataListener = najvaJsonDataListener;
    }

    public static void getCachedJsonData(@NonNull Context context) {
        JSONArray array = JsonFile.getInstance().readFromJsonFile(context);
        if (array == null) return;
        try {
            for (int i = 0; i < array.length(); i++) {
                deliverJsonData(array.getString(i));
            }
            FileManager.deleteCache(context, Parameter.NAJVA_CACHE_FILE_NAME.getValue());
        } catch (JSONException e) {
            //e.printStackTrace();
            //write json to file has problem and must be fixed
        }
    }

    /**
     * @return token after set it in najva server
     * so maybe return null
     */
    @Nullable
    public static String getSubscribedToken(@NonNull Context context){
        String token = FileManager.readFromFile(context, Parameter.TOKEN_FILE_NAME.getValue());
        if (token == null || token.isEmpty())
            return null;
        else {
            return token;
        }
    }

    /**
     * don not call this method
     *
     * @param cookieToken is najva token
     */
    public static void deliverUserSubscribed(String cookieToken) {
        if (userSubscriptionListener != null) {
            userSubscriptionListener.onUserSubscribed(cookieToken);
        }
    }

    public static boolean deliverJsonData(String json) {
        if (najvaJsonDataListener != null) {
            najvaJsonDataListener.onReceiveJson(json);
            return true;
        }
        return false;
    }
}
