package com.najva.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.najva.sdk.core.utils.StaticFields;

public class Najva {

    public static final String ACTION_CLICK_RECEIVED = "com.najva.sdk.Najva.ACTION_CLICK_RECEIVED";
    public static final String ACTION_NOTIFICATION_RECEIVED = "com.najva.sdk.Najva.ACTION_NOTIFICATION_RECEIVED";
    public static final String MESSAGE_ID = StaticFields.DataParameter.MESSAGE_ID;
    public static final String BUTTON_ID = StaticFields.DataParameter.BUTTON_ID;

    public static void initialize(@NonNull Context context) {

        NajvaImpl.initialize(context);

    }

    public static void setUserSubscriptionListener(@Nullable UserSubscriptionListener userSubscriptionListener) {
        NajvaImpl.setUserSubscriptionListener(userSubscriptionListener);
    }

    public static void setNajvaJsonDataListener(@Nullable NajvaJsonDataListener najvaJsonDataListener) {
        NajvaImpl.setNajvaJsonDataListener(najvaJsonDataListener);
    }

    public static void getCachedJsonData(@NonNull Context context) {
        NajvaImpl.getCachedJsonData(context);
    }

    /**
     * @return token after set it in najva server
     * so maybe return null
     */
    @Nullable
    public static String getSubscribedToken(@NonNull Context context){
        return NajvaImpl.getSubscribedToken(context);
    }

}
