package com.najva.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;

import com.najva.sdk.core.utils.StaticFields;

import java.util.HashMap;

/**
 * store necessary params here
 */

public class ClientMetaData {

    private static String token;
    private static String apiKey;
    private static int websiteId;


    private ClientMetaData() {
    }


    public static void setToken(@NonNull String token) {
        ClientMetaData.token = token;
    }

    public static void setApiKey(@NonNull Context context, @NonNull String apiKey) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(StaticFields.SharedPreferencesParameter.NAME, Context.MODE_PRIVATE);
        sharedPreferences.edit().putString(StaticFields.SharedPreferencesParameter.API_KEY, apiKey).apply();
        ClientMetaData.apiKey = apiKey;
    }

    public static void setWebsiteId(int websiteId) {
        ClientMetaData.websiteId = websiteId;
    }


    public static String getApiKey(@NonNull Context context) {
        if (apiKey == null || apiKey.isEmpty()) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(StaticFields.SharedPreferencesParameter.NAME, Context.MODE_PRIVATE);
            apiKey = sharedPreferences.getString(StaticFields.SharedPreferencesParameter.API_KEY, null);
        }
        return apiKey;
    }

    public static int getWebsiteId() {
        return websiteId;
    }


    public static HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put(StaticFields.ServerParameter.TOKEN, token);
        params.put(StaticFields.ServerParameter.API_KEY, apiKey);
        params.put(StaticFields.ServerParameter.WEBSITE_ID, String.valueOf(websiteId));


        return params;
    }
}
