package com.najva.najvasdk.Utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;

import com.najva.najvasdk.BuildConfig;


public class NajvaLog {
    private volatile static boolean enabled;
    private static final String TAG = "NAJVA_SDK";
    private static Handler handler = new Handler(Looper.getMainLooper());

    public static void debug(String message) {
        if (enabled && BuildConfig.DEBUG) {
            if (message != null && !message.isEmpty()) {
                Log.d(TAG, message);
            }
        }
    }

    public static void debugWithToast(final Context context, final String message) {
        if (enabled && BuildConfig.DEBUG) {
            if (message != null && !message.isEmpty()) {
                Log.d(TAG, message);
                handler.post(new Runnable() {
                    public void run() {
                        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                    }
                });

            }
        }
    }

    public static void info(String message) {
        if (enabled) {
            if (message != null && !message.isEmpty()) {
                Log.i(TAG, message);
            }
        }
    }

    public static void warning(String message) {
        if (enabled) {
            if (message != null && !message.isEmpty()) {
                Log.w(TAG, message);
            }
        }
    }

    public static void error(String message) {
        if (enabled) {
            if (message != null && !message.isEmpty()) {
                Log.e(TAG, message);
            }
        }
    }

    public static void fatal(String message) {
        if (enabled) {
            if (message != null && !message.isEmpty()) {
                Log.wtf(TAG, message);
            }
        }
    }

    public static void setEnabled(boolean enabled) {
        NajvaLog.enabled = enabled;
    }
}
