package com.najva.najvasdk.Utils;

import android.content.Context;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class FileSystem {

    public static String readFile(Context context, String filePath) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, filePath);
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }


    public static void saveToFile(Context context, String filePath, ArrayList<String> values){
        File path = getPath(context);

        try {
            File file = new File(path, filePath);
            FileWriter writer = new FileWriter(file);
            for (String val: values){
                writer.write(val);
            }
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getPath(Context context) {
        File path = new File(context.getApplicationContext().getCacheDir(), "najvaFileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }



}
