package com.najva.najvasdk.Utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;

import com.google.android.gms.common.internal.Preconditions;

import java.util.List;


/**
 * A utility class for related device stuff
 */
public class DeviceUtils {

    private DeviceUtils() {}

    /**
     * A helper method for checking a permission is granted or not.
     * In android marshmallow and post-marshmallow, you must grant some permission manually
     * @param context android {@link Context}
     * @param permission desired permission
     * @return true if permission granted
     */
    public static boolean isPermissionGranted(@NonNull final Context context,
                                              @NonNull final String permission) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(permission);

        return ContextCompat.checkSelfPermission(context, permission) ==
                PackageManager.PERMISSION_GRANTED;
    }

    /**
     * Bulk permission check
     * @param context android {@link Context}
     * @param permissions list of desired permissions
     */
    public static void checkPermissionsGranted(
            @NonNull final Context context, @NonNull final List<String> permissions
    ) {

        for (String s: permissions) {
            if ( ! isPermissionGranted(context, s)) {
                throw new RuntimeException(s + " " + "has not provided, you must provide mandatory permissions");
            }
        }

    }
}
