package com.najva.najvasdk.Class;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.widget.ImageView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ImageRequest;
import com.android.volley.toolbox.Volley;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.R;
import com.najva.najvasdk.Utils.NajvaLog;
import com.najva.najvasdk.service.NajvaIntentService;
import com.najva.najvasdk.Utils.IconHandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public final class NajvaPushNotificationHandler {
    private NajvaPushNotificationHandler() {

    }

    public static void handleMessage(Context context, RemoteMessage remoteMessage) {
        if (isNajvaMessage(context, remoteMessage)) {
            String messageId = remoteMessage.getMessageId();

            NajvaLog.debug("Najva push notification received, with messageId: " + messageId);

            Map<String, String> data = remoteMessage.getData();
            ShowNotification(context.getApplicationContext(), data, messageId);

            if(data != null) {
                final String jsonData = data.get("json-data");
                if(jsonData != null && !jsonData.isEmpty()) {

                    NajvaLog.debug("Najva json-data is: " + jsonData);

                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        public void run() {
                            NajvaJsonDataListener listener = Najva.getInstance()
                                    .getNajvaJsonDataListener();
                            if (listener != null) {
                                listener.onReceiveJson(jsonData);
                            }
                        }
                    });
                }
            }
        }
        else {
            NajvaLog.debug("Push notification received, but does not belong to najva!");
        }
    }

    public static void handleNewToken(Context context, String token) {
        NajvaLog.debugWithToast(context, "New FCM token: " + token);
        updateSubscriptionFile(context);
        Najva.getInstance().updateSubscriber(token);
    }

    public static boolean isNajvaMessage(Context context, RemoteMessage remoteMessage) {
        boolean result = false;
        Map<String, String> data = remoteMessage.getData();
        if (data != null) {
            String apiKey = data.get("api_key");
            SharedPreferences sharedPreferences = context.getSharedPreferences("najva", Context.MODE_PRIVATE);
            String localApiKey = sharedPreferences.getString("api_key", null);

            if (localApiKey == null) {
                NajvaLog.error("You must call Najva.initialize() before using isNajvaMessage method");
                result = false;
            }
            else if (apiKey == null) {
                NajvaLog.error("Provide api_key from message is null, contact support!");
                result = false;
            }
            else {
                result = apiKey.equals(localApiKey);
                if (!result) {
                    NajvaLog.error("Provide api_key from message is not equal to localApiKey.");
                }
            }
        }

        return result;
    }

    private static void ShowNotification(final Context context, final Map<String, String> data, final String messageId) {
        final String notificationId = data.get("notification_id");
        final String finalAddress = data.get("url");
        final String onClickAction = data.get("onclick_action");
        String notificationContent = data.get("notification_content");
        final String priority = data.get("priority");

        if (notificationContent == null) {
            notificationContent = "";
        }

        final PendingIntent pendingIntent = setNotificationAction(
                context,
                onClickAction,
                Integer.parseInt(notificationId),
                finalAddress,
                notificationContent,
                messageId,
                Parameter.ORIGINAL_CLICK_TYPE.getValue(),
                -1
        );


        final Notification.Builder notificationBuilder = new Notification.Builder(context);
        notificationBuilder
                .setContentTitle(data.get("title"))
                .setContentText(data.get("body"))
                .setAutoCancel(true);

        // Since android Oreo notification channel is needed.
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationManager mNotificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            String channelId = context.getString(R.string.default_notification_channel_id);

            int notificationPriority = NotificationManager.IMPORTANCE_DEFAULT;
            if (priority != null) {
                if (priority.equalsIgnoreCase("High")) {
                    notificationPriority = NotificationManager.IMPORTANCE_HIGH;
                } else if (priority.equalsIgnoreCase("Low")) {
                    notificationPriority = NotificationManager.IMPORTANCE_DEFAULT;
                }
            }

            NotificationChannel channel = new NotificationChannel(channelId, "title", notificationPriority);
            channel.setDescription("body");
            assert mNotificationManager != null;
            mNotificationManager.createNotificationChannel(channel);
            notificationBuilder.setChannelId(channelId);
        } else {

            if (priority != null && Build.VERSION.SDK_INT >= 16) {
                if (priority.equalsIgnoreCase("High")) {
                    notificationBuilder.setPriority(Notification.PRIORITY_HIGH);
                } else if (priority.equalsIgnoreCase("Low")) {
                    notificationBuilder.setPriority(Notification.PRIORITY_LOW);
                }
            }
        }


        if (pendingIntent != null) {
            notificationBuilder.setContentIntent(pendingIntent);
        }


        if (data.get("light_up_screen") != null && data.get("light_up_screen").equalsIgnoreCase("true")) {
            PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
            boolean isScreenOn = pm.isScreenOn();
            if (!isScreenOn) {
                PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, "najva:MyLock");
                wl.acquire(1000);
                PowerManager.WakeLock wl_cpu = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "najva:MyCpuLock");

                wl_cpu.acquire(1000);
            }
        }

        if (data.get("btn1_enabled") != null && data.get("btn1_enabled").equalsIgnoreCase("true") && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            String btn1Title = "";
            String btn1Action = "close";
            String btn1FinalAddress = "";
            String btn1Content = "";
            int btn1Icon = 0;
            int btn1Id = 0;
            if (data.get("btn1_title") != null) {
                btn1Title = data.get("btn1_title");
            }
            if (data.get("btn1_icon") != null) {
                int iconCode = 0;
                try {
                    iconCode = Integer.valueOf(data.get("btn1_icon"));
                } catch (Exception e) {
                }

                btn1Icon = IconHandler.getNotificationButtonIcon(iconCode);
            }

            if (data.get("btn1_id") != null) {
                btn1Id = Integer.valueOf(data.get("btn1_id"));
            }

            if (data.get("btn1_action") != null) {
                btn1Action = data.get("btn1_action");
            }

            if (data.get("btn1_final_address") != null) {
                btn1FinalAddress = data.get("btn1_final_address");
            }

            if (data.get("btn1_content") != null) {
                btn1Content = data.get("btn1_content");
            }

            PendingIntent buttonPendingIntent = setNotificationAction(
                    context,
                    btn1Action,
                    Integer.parseInt(notificationId),
                    btn1FinalAddress,
                    btn1Content,
                    messageId,
                    Parameter.BUTTON_CLICK_TYPE.getValue(),
                    btn1Id
            );
            notificationBuilder.addAction(btn1Icon, btn1Title, buttonPendingIntent);
        }

        if (data.get("btn2_enabled") != null && data.get("btn2_enabled").equalsIgnoreCase("true") && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            String btn2Title = "";
            String btn2Action = "close";
            String btn2FinalAddress = "";
            String btn2Content = "";
            int btn2Icon = 0;
            int btn2Id = 0;
            if (data.get("btn2_title") != null) {
                btn2Title = data.get("btn2_title");
            }
            if (data.get("btn2_icon") != null) {
                int iconCode = 0;
                try {
                    iconCode = Integer.valueOf(data.get("btn2_icon"));
                } catch (Exception e) {
                }

                btn2Icon = IconHandler.getNotificationButtonIcon(iconCode);
            }

            if (data.get("btn2_id") != null) {
                btn2Id = Integer.valueOf(data.get("btn2_id"));
            }

            if (data.get("btn2_action") != null) {
                btn2Action = data.get("btn2_action");
            }

            if (data.get("btn2_final_address") != null) {
                btn2FinalAddress = data.get("btn2_final_address");
            }

            if (data.get("btn2_content") != null) {
                btn2Content = data.get("btn2_content");
            }

            PendingIntent buttonPendingIntent = setNotificationAction(
                    context,
                    btn2Action,
                    Integer.parseInt(notificationId),
                    btn2FinalAddress,
                    btn2Content,
                    messageId,
                    Parameter.BUTTON_CLICK_TYPE.getValue(),
                    btn2Id
            );

            notificationBuilder.addAction(btn2Icon, btn2Title, buttonPendingIntent);
        }


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            if (data.get("icon") == null) {
                if (data.get("image") != null) {
                    RequestQueue queue = Volley.newRequestQueue(context);
                    ImageRequest imageRequest = new ImageRequest(data.get("image"), new Response.Listener<Bitmap>() {
                        public void onResponse(Bitmap response) {

                            if (response != null && Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {

                                Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle()
                                        .bigPicture(response)
                                        .setBigContentTitle(data.get("title"))
                                        .setSummaryText(data.get("body"));

                                notificationBuilder.setStyle(bigPictureStyle);
                                notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                                notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                                notificationBuilder.setLights(Color.BLUE, 1000, 300);

                                NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                                assert notificationManager != null;

                                if (Build.VERSION.SDK_INT < 16) {
                                    notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                                } else {
                                    notificationManager.notify(messageId, 0, notificationBuilder.build());
                                }

                            }

                        }
                    }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            VolleyLog.wtf(error.getMessage(), "utf-8");
                            NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    });
                    imageRequest.setRetryPolicy(new DefaultRetryPolicy(
                            10 * 1000,
                            3,
                            DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                    queue.add(imageRequest);


                } else {
                    notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                    notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                    notificationBuilder.setLights(Color.BLUE, 1000, 300);

                    NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                    assert notificationManager != null;

                    if (Build.VERSION.SDK_INT < 16) {
                        notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                    } else {
                        notificationManager.notify(messageId, 0, notificationBuilder.build());
                    }
                }
            } else {
                if (data.get("image") == null) {
                    RequestQueue queue = Volley.newRequestQueue(context);
                    ImageRequest imageRequest = new ImageRequest(data.get("icon"), new Response.Listener<Bitmap>() {
                        public void onResponse(Bitmap response) {

                            if (response != null) {
                                notificationBuilder.setLargeIcon(response);
                                notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                                notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                                notificationBuilder.setLights(Color.BLUE, 1000, 300);

                                NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                                assert notificationManager != null;

                                if (Build.VERSION.SDK_INT < 16) {
                                    notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                                } else {
                                    notificationManager.notify(messageId, 0, notificationBuilder.build());
                                }

                            }

                        }
                    }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            VolleyLog.wtf(error.getMessage(), "utf-8");
                            NajvaLog.error( "Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    });
                    imageRequest.setRetryPolicy(new DefaultRetryPolicy(
                            10 * 1000,
                            3,
                            DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                    queue.add(imageRequest);


                } else {
                    RequestQueue queue = Volley.newRequestQueue(context);
                    ImageRequest imageRequest = new ImageRequest(data.get("icon"), new Response.Listener<Bitmap>() {
                        public void onResponse(final Bitmap iconResponse) {

                            if (iconResponse != null) {


                                RequestQueue queue = Volley.newRequestQueue(context);
                                ImageRequest imageRequest = new ImageRequest(data.get("image"), new Response.Listener<Bitmap>() {
                                    public void onResponse(Bitmap imageResponse) {
                                        if (imageResponse != null && Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                                            Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle()
                                                    .bigPicture(imageResponse)
                                                    .setBigContentTitle(data.get("title"))
                                                    .setSummaryText(data.get("body"));

                                            notificationBuilder.setLargeIcon(iconResponse);
                                            notificationBuilder.setStyle(bigPictureStyle);
                                            notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                                            notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                                            notificationBuilder.setLights(Color.BLUE, 1000, 300);

                                            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                                            assert notificationManager != null;

                                            if (Build.VERSION.SDK_INT < 16) {
                                                notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                                            } else {
                                                notificationManager.notify(messageId, 0, notificationBuilder.build());
                                            }
                                        }
                                    }
                                }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
                                    @Override
                                    public void onErrorResponse(VolleyError error) {
                                        VolleyLog.wtf(error.getMessage(), "utf-8");
                                        NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                                    }
                                });
                                imageRequest.setRetryPolicy(new DefaultRetryPolicy(
                                        10 * 1000,
                                        3,
                                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                                queue.add(imageRequest);


                            }

                        }
                    }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            VolleyLog.wtf(error.getMessage(), "utf-8");
                            NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    });
                    imageRequest.setRetryPolicy(new DefaultRetryPolicy(
                            10 * 1000,
                            3,
                            DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                    queue.add(imageRequest);

                }
            }
        } else {
            if (data.get("icon") != null) {
                RequestQueue queue = Volley.newRequestQueue(context);
                ImageRequest imageRequest = new ImageRequest(data.get("icon"), new Response.Listener<Bitmap>() {
                    public void onResponse(Bitmap response) {

                        if (response != null) {
                            notificationBuilder.setLargeIcon(response);
                            notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                            notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                            notificationBuilder.setLights(Color.BLUE, 1000, 300);

                            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                            assert notificationManager != null;

                            if (Build.VERSION.SDK_INT < 16) {
                                notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                            } else {
                                notificationManager.notify(messageId, 0, notificationBuilder.build());
                            }

                        }

                    }
                }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        VolleyLog.wtf(error.getMessage(), "utf-8");
                        NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                    }
                });
                imageRequest.setRetryPolicy(new DefaultRetryPolicy(
                        10 * 1000,
                        3,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                queue.add(imageRequest);
            } else {
                notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                notificationBuilder.setLights(Color.BLUE, 1000, 300);

                NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                assert notificationManager != null;

                if (Build.VERSION.SDK_INT < 16) {
                    notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                } else {
                    notificationManager.notify(messageId, 0, notificationBuilder.build());
                }
            }

        }

    }

    private static void updateSubscriptionFile(Context context) {
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("0");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<String> getWebsiteInfo(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() < 2) {
                records.set(0, "0");
                records.set(1, null);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return records;

    }

    private static File getPath(Context context) {
        File path = new File(context.getCacheDir(), "najvaFileDir");
        if (!path.exists()) {
            path.mkdir();
        }

        return path;
    }

    private static PendingIntent setNotificationAction(Context context, String notificationAction,
                                                       int notificationId, String finalAddress,
                                                       String notificationContent, String messageId,
                                                       String clickType, int button_id) {

        //replaced with old reflection code
        Intent notificationIntent = new Intent(context, NajvaIntentService.class);

        // firebase message_id for notification_id is unique
        notificationIntent.putExtra("message_id", messageId);
        notificationIntent.putExtra("onclick_action", notificationAction);
        notificationIntent.putExtra("final_address", finalAddress);
        notificationIntent.putExtra("notification_id", notificationId);
        notificationIntent.putExtra("website_info", getWebsiteInfo(context));
        notificationIntent.putExtra("notification_content", notificationContent);
        // click on notification or on a button of notification?
        notificationIntent.putExtra("click_type", clickType);
        // button-id
        if (button_id > 0) {
            notificationIntent.putExtra("button_id", button_id);
        }

        // generate random integer for pending intent unique
        int dummyUniqueInt = new Random().nextInt(543254);
        return PendingIntent.getService(context, dummyUniqueInt, notificationIntent, PendingIntent.FLAG_ONE_SHOT);

    }
}
