package com.najva.najvasdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.MetaFormRequest;
import com.najva.najvasdk.Utils.NajvaLog;
import com.najva.najvasdk.Utils.Network;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NetworkReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (Network.isConnected(context)){
            sendClickLogs(context);
            sendButtonClickLog(context);
        }
    }

    private void sendButtonClickLog(final Context context){
        ArrayList<String[]> logs = getClickLogs(context, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
        if (logs == null){
            return;
        }

        for (int i = 0; i < logs.size(); i++){
            final String[] log = logs.get(i);
            RequestQueue queue = Volley.newRequestQueue(context);
            MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.BUTTON_CLICK_LOG.getValue(),
                    new Response.Listener<String>()
                    {
                        @Override
                        public void onResponse(String response) {
                        }
                    },
                    new Response.ErrorListener()
                    {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    }
            ) {
                @Override
                protected Map<String, String> getParams()
                {
                    return getButtonParameters(log);
                }

                @Override
                public Map<String, String> getHeaders() throws AuthFailureError {
                    Map<String, String> headers = super.getHeaders();

                    if (headers == null
                            || headers.equals(Collections.emptyMap())) {
                        headers = new HashMap<String, String>();
                    }
                    headers.put("Cookie", getCookie(context));

                    return headers;
                }
            };
            postRequest.setRetryPolicy(new DefaultRetryPolicy(
                    60 * 1000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
            queue.add(postRequest);

//            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.BUTTON_CLICK_LOG.getValue(),
//                    null, null, getButtonParameters(log), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
//                        @Override
//                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                        }
//                    });
        }

        clearButtonClickLogs(context);
    }

    private void sendClickLogs(final Context context){
        ArrayList<String[]> logs = getClickLogs(context, Parameter.CLICK_LOGS_FILE_NAME.getValue());
        if (logs == null){
            return;
        }

        for (int i = 0; i < logs.size(); i++){
            final String[] log = logs.get(i);

            RequestQueue queue = Volley.newRequestQueue(context);
            MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.CLICK_LOG.getValue(),
                    new Response.Listener<String>()
                    {
                        @Override
                        public void onResponse(String response) {
                        }
                    },
                    new Response.ErrorListener()
                    {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    }
            ) {
                @Override
                protected Map<String, String> getParams()
                {
                    return getParameters(context, log);
                }

                @Override
                public Map<String, String> getHeaders() throws AuthFailureError {
                    Map<String, String> headers = super.getHeaders();

                    if (headers == null
                            || headers.equals(Collections.emptyMap())) {
                        headers = new HashMap<String, String>();
                    }
                    headers.put("Cookie", getCookie(context));

                    return headers;
                }
            };
            postRequest.setRetryPolicy(new DefaultRetryPolicy(
                    60 * 1000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
            queue.add(postRequest);

//            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CLICK_LOG.getValue(),
//                    null, null, getParameters(context, log), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
//                        @Override
//                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//
//                        }
//                    });
        }

        clearClickLogs(context);

    }

    private HashMap<String, String> getParameters(Context context, String[] log){
        HashMap<String, String> params = new HashMap<>();

        if (log.length != 3){
            return params;
        }

        params.put("api_key", log[0]);
        params.put("website_id", log[1]);
        params.put("notification_id", log[2]);

        String najvaToken = this.getCookie(context);
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            } catch (Exception ignored) {}
        }

        return params;
    }

    private HashMap<String, String> getButtonParameters(String[] log) {
        HashMap<String, String> params = new HashMap<>();

        if (log.length != 4){
            return params;
        }

        params.put("api_key", log[0]);
        params.put("website_id", log[1]);
        params.put("notification_id", log[2]);
        params.put("button_id", log[3]);

        return params;
    }

    private ArrayList<String[]> getClickLogs(Context context, String fileName){
        ArrayList<String[]> clickLogs = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, fileName);
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                String[] log = line.split(":");
                clickLogs.add(log);
            }
            reader.close();

            if (clickLogs.size() > 0) {
                return clickLogs;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private String getCookie(Context context){
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private void clearClickLogs(Context context){
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void clearButtonClickLogs(Context context){
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context){
        File path = new File(context.getCacheDir(), "najvaFileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }
}
