package com.najva.najvasdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.MetaFormRequest;
import com.najva.najvasdk.Utils.NajvaLog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChangeSimcardReceiver extends BroadcastReceiver{
    @Override
    public void onReceive(Context context, Intent intent) {
        String newOperator = getSimOperatorName(context);
        if (!newOperator.equalsIgnoreCase(getLastSimcardOperator(context))){
            saveNewOperator(context);
            sendNewOperatorToServer(context);
        }
    }

    private String getSimOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    private String getLastSimcardOperator(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return "";
    }

    private void saveNewOperator(Context context) {
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write(getSimOperatorName(context));
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getCacheDir(), "najvaFileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private void sendNewOperatorToServer(final Context context) {
        RequestQueue queue = Volley.newRequestQueue(context);
        MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.UPDATE_OPERATOR.getValue(),
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        NajvaLog.error("Error response, " + (error != null ? error.getMessage() : ""));
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                return getOperatorParams(getSimOperatorName(context));
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = super.getHeaders();

                if (headers == null
                        || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", getCookie(context));

                return headers;
            }
        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(
                60 * 1000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(postRequest);
//        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null,
//                getOperatorParams(getSimOperatorName(context)), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
//                    @Override
//                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                    }
//                });
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private HashMap<String, String> getOperatorParams(String operator) {
        HashMap<String, String> params = new HashMap<>();
        params.put("operator", operator);

        return params;
    }
}
