package com.najva.najvasdk.Service;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.najvasdk.Class.NajvaPushNotificationHandler;


/**
 * Created by sina on 9/16/2018.
 */
public class NajvaMessagingService extends FirebaseMessagingService {

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        NajvaPushNotificationHandler.handleMessage(getApplicationContext(), remoteMessage);
    }

    @Override
    public void onNewToken(String s) {
        super.onNewToken(s);
        NajvaPushNotificationHandler.handleNewToken(getApplicationContext(), s);
    }
}
