package com.najva.najvasdk.Class;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.FileSystem;
import com.najva.najvasdk.Utils.LocationManagerApiWrapper;
import com.najva.najvasdk.Utils.MetaFormRequest;
import com.najva.najvasdk.Utils.MetaJsonRequest;

import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by sina on 9/19/2018.
 */
public class Najva {
    private static Najva najva;
    private String token;
    private String apiKey;
    private int websiteId;
    private int campaignId;
    private boolean location;
    private Context context;
    private NajvaUserHandler najvaUserHandler;
    private NajvaJsonDataListener najvaJsonDataListener;

    public static final String NAJVA_SDK_TAG = "NAJVA_SDK";

    public static void initialize(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        getInstance().init(context, campaignId, websiteId, apiKey, location);
    }

    public static void setUserHandler(NajvaUserHandler najvaUserHandler) {
        getInstance().setNajvaUserHandler(najvaUserHandler);
    }

    public static void setJsonDataListener(NajvaJsonDataListener listener) {
        getInstance().najvaJsonDataListener = listener;
    }

    public NajvaJsonDataListener getNajvaJsonDataListener() {
        return najvaJsonDataListener;
    }

    public static Najva getInstance() {
        if (najva == null) {
            synchronized (Najva.class) {
                if(najva == null) {
                    najva = new Najva();
                }
            }
        }
        return najva;
    }

    private void init(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        this.apiKey = apiKey;
        this.websiteId = websiteId;
        this.campaignId = campaignId;
        this.location = location;
        this.context = context;
        this.najvaUserHandler = new NajvaUserHandler();


        SharedPreferences sharedPreferences = context.getSharedPreferences("najva", Context.MODE_PRIVATE);
        sharedPreferences.edit().putString("api_key", apiKey).apply();

        FirebaseOptions options = new FirebaseOptions.Builder()
                .setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()) // Required for Analytics.
                .setApiKey(Parameter.FIREBASE_API_KEY.getValue()) // Required for Auth.
                .setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()) // Required for RTDB.
                .build();

        try {
            FirebaseApp.getInstance("NAJVA_SDK_FIREBASE");
        } catch (IllegalStateException e) {
            // Initialize with api_key app.
            // TODO - Client will be crashed if init method called multiple times because of this line
            FirebaseApp.initializeApp(context /* Context */, options, "NAJVA_SDK_FIREBASE");
        }


        // save website_id and api_key in file
        saveWebsiteInfo();

        if (this.location) {
            try {
                this.setLocationRequest();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        // check app-version every day
        checkAppVersion();

        // update last-login
        updateLastLogin();
    }

    private void setNajvaUserHandler(NajvaUserHandler najvaUserHandler) {
        this.najvaUserHandler = najvaUserHandler;
    }

    public void updateSubscriber(String token) {
        this.token = token;

        try {
            addSubscriberToCampaign(context, getParams(), location);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addSubscriberToCampaign(final Context context, final HashMap<String, String> params, final boolean location) throws IOException {

        if (isSubscribed()) {
            System.out.println("already subscribed!");
            return;
        }

        RequestQueue queue = Volley.newRequestQueue(context);
        MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.ADD_SUBSCRIBER_URL.getValue(),
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        updateSubscriptionFile(context);
                        if (location) {
                            try {
                                setLocationRequest();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                        // syncing najva user and application user!
                        try {
                            JSONObject jsonObj = new JSONObject(response);
                            String cookieToken = (String) jsonObj.get("cookie_token");
                            Najva.getInstance().handleNajvaUser(cookieToken);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        } catch (NullPointerException ignored){}

                        createDeviceInfoRequest();
                        saveSimOperator();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Log.e(NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                return params;
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = super.getHeaders();

                if (headers == null
                        || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", getCookie());

                return headers;
            }

            @Override
            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                for (com.android.volley.Header h: response.allHeaders) {
                    if (h.getName().equalsIgnoreCase("Set-Cookie")) {
                        saveCookie(h.getValue());
//                        Log.d("coooookies", h.getValue());
                    }
                }

                return super.parseNetworkResponse(response);
            }
        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(
                60 * 1000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(postRequest);


//        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(),
//                ApiInfo.ADD_SUBSCRIBER_URL.getValue(), null, null,
//                params, "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                    @Override
//                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                        if (responseStatus(response) == 200) {
//                            updateSubscriptionFile(context);
//                            saveCookie(response);
//                        }
//
//
//                        if (location && responseStatus(response) == 200) {
//                            try {
//                                setLocationRequest();
//                            } catch (IOException e) {
//                                e.printStackTrace();
//                            }
//                        }
//
//                        createDeviceInfoRequest();
//                        saveSimOperator();
//
//                    }
//                });

    }

    private void setLocationRequest() throws IOException {
        if (!isSubscribed()) {
            return;
        }

        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions((Activity) context, new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 1);

        } else {
            if (!checkLocationStatus()) {
                return;
            }


            Location currentLocation = LocationManagerApiWrapper.getInstance(context).getLocation(context);
            // Got last known location. In some rare situations this can be null.
            if (currentLocation != null) {
                RequestQueue queue = Volley.newRequestQueue(context);
                JSONObject jsonBody = new JSONObject(getLocationParams(currentLocation));
                MetaJsonRequest postRequest = new MetaJsonRequest(ApiInfo.SET_LOCATION_URL.getValue(), jsonBody,
                        new Response.Listener<JSONObject>()
                        {
                            @Override
                            public void onResponse(JSONObject response) {

                                saveLastLocationTime();

                            }
                        },
                        new Response.ErrorListener()
                        {
                            @Override
                            public void onErrorResponse(VolleyError error) {
                                Log.e(NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                            }
                        }
                ) {

                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        Map<String, String> headers = super.getHeaders();

                        if (headers == null
                                || headers.equals(Collections.emptyMap())) {
                            headers = new HashMap<String, String>();
                        }
                        headers.put("Cookie", getCookie());
                        headers.put("Content-Type", "application/json");

                        return headers;
                    }

                    @Override
                    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
                        try {
                            Map<String, String> headers = response.headers;
                            String cookies = null;
                            try {
                                cookies = headers.get("Set-Cookie");
                            } catch (Exception ignored){}

                            if (cookies != null) {
                                saveCookie(cookies);
                            }
                        } catch (Exception ignored) {}

                        return super.parseNetworkResponse(response);
                    }

                };

                postRequest.setRetryPolicy(new DefaultRetryPolicy(
                        60 * 1000,
                        3,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                queue.add(postRequest);

//                                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.SET_LOCATION_URL.getValue(),
//                                        null, null, getLocationParams(currentLocation), "application/json", getCookie(), new IResponse() {
//                                            @Override
//                                            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                                                saveCookie(response);
//                                                if (responseStatus(response) == 200) {
//                                                    saveLastLocationTime();
//                                                }
//                                            }
//                                        });
            }


        }
    }

    private void createDeviceInfoRequest() {

        RequestQueue queue = Volley.newRequestQueue(context);
        MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.CREATE_DEVICE_INFO.getValue(),
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Log.e(NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                return getDeviceInfoParams();
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = super.getHeaders();

                if (headers == null
                        || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", getCookie());
                return headers;
            }

        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(
                60 * 1000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(postRequest);
//
//        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CREATE_DEVICE_INFO.getValue(), null, null,
//                getDeviceInfoParams(), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                    @Override
//                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                    }
//                });
    }


    private int responseStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }


    private HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("token_id", this.token);
        params.put("api_key", this.apiKey);
        params.put("website_id", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));

        return params;
    }

    private HashMap<String, String> getLocationParams(Location locationObject) {
        HashMap<String, String> params = new HashMap<>();

        if (locationObject != null) {
            params.put("latitude", String.valueOf(locationObject.getLatitude()));
            params.put("longitude", String.valueOf(locationObject.getLongitude()));
            params.put("altitude", String.valueOf(locationObject.getAltitude()));
            params.put("accuracy", String.valueOf(locationObject.getAccuracy()));
        }

        return params;
    }

    private HashMap<String, String> getDeviceInfoParams(){
        HashMap<String, String> params = new HashMap<>();

        params.put("sim_operator_name", getSimOperatorName());
        params.put("device_model", getDeviceModel());
        params.put("android_version", getAndroidVersion());
        params.put("android_id", getAndroidId());

        String encodedPackageInfo = getPackageInfo();
        try {
            encodedPackageInfo = URLEncoder.encode(encodedPackageInfo, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put("android_package_info", encodedPackageInfo);
        params.put("manufacturer", Build.MANUFACTURER);
        params.put("app_version", getAppVersion());

        return params;
    }

    private boolean isSubscribed() {
        String value = FileSystem.readFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());

        return value != null && Integer.valueOf(value) == 1;
    }

    private void updateSubscriptionFile(Context context) {
        ArrayList<String> values = new ArrayList<>();
        values.add("1");
        FileSystem.saveToFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue(), values);
    }

    private String getCookie() {
        return FileSystem.readFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
    }

    private void saveCookie(String cookies) {
        if (cookies != null && cookies.contains("najva_token")) {
            int idx = cookies.indexOf("najva_token=");
            int offset_idx = 0;
            while (cookies.charAt(idx + offset_idx) != ';'){
                offset_idx ++;
            }
            String najva_token = cookies.substring(idx, idx + offset_idx + 1);
            updateCookie(najva_token);
        }
    }

//    private void saveCookie(HttpResponse response) {
//        if (response.getHeaders("Set-Cookie").length > 0) {
//            for (Header h : response.getHeaders("Set-Cookie")) {
//                if (h.getValue().contains("najva_token")) {
//                    String cookie = "najva_token=" + h.getValue().substring(h.getValue().indexOf("=") + 1, h.getValue().indexOf(";") + 1);
//                    updateCookie(cookie);
//                }
//            }
//        }
//    }

    private void updateCookie(String cookie) {
        ArrayList<String> values = new ArrayList<>();
        values.add(cookie);
        FileSystem.saveToFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue(), values);
    }

    private void saveLastLocationTime() {
        ArrayList<String> values = new ArrayList<>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue(), values);
    }

    private boolean checkLocationStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(12)).before(lastDate)) {
                return false;
            }
        }

        return true;
    }

    private void saveWebsiteInfo() {
        ArrayList<String> values = new ArrayList<>();
        values.add(String.valueOf(this.websiteId));
        values.add(System.getProperty("line.separator"));
        values.add(this.apiKey);

        FileSystem.saveToFile(this.context, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue(), values);
    }

    private void saveSimOperator() {
        ArrayList<String> values = new ArrayList<>();
        values.add(getSimOperatorName());
        FileSystem.saveToFile(this.context, Parameter.OPERATOR_NAME_FILE_NAME.getValue(), values);
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private static String getDeviceModel() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    private String getAndroidId() {
        @SuppressLint("HardwareIds") String androidId = Settings.Secure.getString(context.getContentResolver(),
                Settings.Secure.ANDROID_ID);
        return androidId;
    }


    private String getSimOperatorName() {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    private String getAndroidVersion(){
        return String.valueOf(Build.VERSION.RELEASE);
    }

    private String getPackageInfo(){
        StringBuilder jsonResponse = new StringBuilder("[");
        PackageManager packageManager = context.getPackageManager();
        List<ApplicationInfo> installedApplications =
                packageManager.getInstalledApplications(PackageManager.GET_META_DATA);

        for (ApplicationInfo appInfo : installedApplications) {
            jsonResponse.append("{\"package_name\": ").append("\"").append(appInfo.packageName).append("\"").append(", ").append("\"app_label\": ").append("\"").append(appInfo.loadLabel(packageManager)).append("\"").append("}, ");
        }
        if (jsonResponse.length() > 1){
            jsonResponse = new StringBuilder(jsonResponse.substring(0, jsonResponse.length() - 2));
        }
        jsonResponse.append("]");

        return jsonResponse.toString();

    }

    private String getAppVersion() {
        String version = "";
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            version = pInfo.versionName;
            System.out.println(version == null);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }


    private void checkAppVersion() {
        String lastVersion = getLastAppVersionSaved();
        final String currentVersion = getAppVersion();
        if (lastVersion == null) {
            saveLastAppVersion();

        }else if (!lastVersion.equalsIgnoreCase(currentVersion)) {
            RequestQueue queue = Volley.newRequestQueue(context);
            MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.UPDATE_OPERATOR.getValue(),
                    new Response.Listener<String>()
                    {
                        @Override
                        public void onResponse(String response) {
                        }
                    },
                    new Response.ErrorListener()
                    {
                        @Override
                        public void onErrorResponse(VolleyError error) {
                            Log.e(NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                        }
                    }
            ) {
                @Override
                protected Map<String, String> getParams()
                {
                    return getAppVersionParams(currentVersion);
                }

                @Override
                public Map<String, String> getHeaders() throws AuthFailureError {
                    Map<String, String> headers = super.getHeaders();

                    if (headers == null
                            || headers.equals(Collections.emptyMap())) {
                        headers = new HashMap<String, String>();
                    }
                    headers.put("Cookie", getCookie());

                    return headers;
                }

            };
            postRequest.setRetryPolicy(new DefaultRetryPolicy(
                    60 * 1000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
            queue.add(postRequest);

//            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null,
//                    getAppVersionParams(currentVersion), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                        @Override
//                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                            if (responseStatus(response) == 200){
//                                saveLastAppVersion();
//                            }
//                        }
//                    });
        }
    }

    private void saveLastAppVersion() {
        ArrayList<String> values = new ArrayList<>();
        values.add(getAppVersion());
        FileSystem.saveToFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue(), values);
    }

    private String getLastAppVersionSaved() {
        String val = FileSystem.readFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue());
        return val;
    }

    private HashMap<String, String> getAppVersionParams(String newVersion) {
        HashMap<String, String> params = new HashMap<>();
        params.put("app_version", newVersion);
        return params;
    }

    private void updateLastLogin() {
        if (!checkLastLoginTimeStatus() || !isSubscribed()) {
            return;
        }

        StringBuilder currentUrl = new StringBuilder(ApiInfo.API_CURRENT_USER.getValue() + "?");
        HashMap<String, String> lastUpdateTimeParams = getLastUpdateTimeParams();
        for (String key: lastUpdateTimeParams.keySet()) {
            currentUrl.append(key).append("=").append(lastUpdateTimeParams.get(key)).append("&");
        }
        if (lastUpdateTimeParams.size() > 0) {
            currentUrl.deleteCharAt(currentUrl.length() - 1);
        }
        String url = currentUrl.toString();
        RequestQueue queue = Volley.newRequestQueue(context);
        MetaFormRequest postRequest = new MetaFormRequest(Request.Method.GET,
                url,
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        saveLastLoginTime();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Log.e(NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                    }
                }
        ) {
//            @Override
//            protected Map<String, String> getParams()
//            {
//                return getLastUpdateTimeParams();
//            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = super.getHeaders();

                if (headers == null
                        || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", getCookie());

                return headers;
            }

            @Override
            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                Map<String, String> headers = response.headers;
                String cookies = null;
                try {
                    cookies = headers.get("Set-Cookie");
                } catch (Exception ignored){}

                if (cookies != null) {
                    saveCookie(cookies);
                }

                return super.parseNetworkResponse(response);
            }

        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(
                60 * 1000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(postRequest);

//        HttpHandleResponse.sendRequest("GET", ApiInfo.HOST.getValue(), ApiInfo.API_CURRENT_USER.getValue(),
//                null, null, getLastUpdateTimeParams(), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                    @Override
//                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                        saveCookie(response);
//                        if (responseStatus(response) == 200) {
//                            saveLastLoginTime();
//                        }
//                    }
//                });


    }


    private HashMap<String, String> getLastUpdateTimeParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("update_time", "1");
        params.put("get_token", "1");
        params.put("api_key", this.apiKey);
        params.put("website", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));

        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            }catch (Exception ignored) {}
        }

        return params;
    }

    private void saveLastLoginTime() {
        ArrayList<String> values = new ArrayList<>();
//        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        @SuppressLint("SimpleDateFormat") SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        values.add(formatter.format(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue(), values);
    }

    private boolean checkLastLoginTimeStatus() {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String value = FileSystem.readFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue());
        if (value != null) {
            try {
                Date lastDate = formatter.parse(value);
                if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24)).before(lastDate) && lastDate.getDay() == new Date(System.currentTimeMillis()).getDay()) {
                    return false;
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }

        }

        return true;
    }

    public void handleNajvaUser(String token) {
        this.najvaUserHandler.najvaUserSubscribed(token);
    }

}