package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.MetaFormRequest;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InstallPackageReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String packageName = intent.getData().getEncodedSchemeSpecificPart();
        PackageManager packageManager= context.getPackageManager();
        String appLabel = "";
        try {
            appLabel = (String) packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, PackageManager.GET_META_DATA));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        addPackageInfoRequest(context, packageName, appLabel);
    }

    private void addPackageInfoRequest(final Context context, final String packageName, final String appLabel) {
        RequestQueue queue = Volley.newRequestQueue(context);
        MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.CHANGE_DEVICE_INFO.getValue(),
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Log.e(Najva.NAJVA_SDK_TAG, "Error response, " + (error != null ? error.getMessage() : ""));
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                return getPackageInfoParams(packageName, appLabel);
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = super.getHeaders();

                if (headers == null
                        || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", getCookie(context));

                return headers;
            }
        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(
                60 * 1000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(postRequest);

//        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CHANGE_DEVICE_INFO.getValue(), null, null,
//                getPackageInfoParams(packageName, appLabel), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
//                    @Override
//                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                    }
//                });
    }

    private HashMap<String, String> getPackageInfoParams(String packageName, String appLabel) {
        HashMap<String, String> params = new HashMap<>();

        String encodedAppLable = appLabel;
        try {
            encodedAppLable = URLEncoder.encode(encodedAppLable, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put("operation", "add");
        params.put("package_name", packageName);
        params.put("app_label", encodedAppLable);

        return params;
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

}
