/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.PowerManager;
import android.widget.ImageView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ImageRequest;
import com.android.volley.toolbox.Volley;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.R;
import com.najva.najvasdk.Utils.IconHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class NajvaMessagingService
extends FirebaseMessagingService {
    public void onMessageReceived(RemoteMessage remoteMessage) {
        String messageId = remoteMessage.getMessageId();
        Map data = remoteMessage.getData();
        this.ShowNotification(data, messageId);
    }

    private void ShowNotification(final Map<String, String> data, final String messageId) {
        NotificationManager notificationManager;
        ImageRequest imageRequest;
        RequestQueue queue;
        PowerManager pm;
        boolean isScreenOn;
        String notificationId = data.get("notification_id");
        String finalAddress = data.get("url");
        String onClickAction = data.get("onclick_action");
        String notificationContent = data.get("notification_content");
        String priority = data.get("priority");
        if (notificationContent == null) {
            notificationContent = "";
        }
        PendingIntent pendingIntent = this.setNotificationAction(onClickAction, Integer.parseInt(notificationId), finalAddress, notificationContent, messageId, Parameter.ORIGINAL_CLICK_TYPE.getValue(), -1);
        final Notification.Builder notificationBuilder = new Notification.Builder(this.getApplicationContext());
        notificationBuilder.setContentTitle((CharSequence)data.get("title")).setContentText((CharSequence)data.get("body")).setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
            String channelId = this.getApplicationContext().getString(R.string.default_notification_channel_id);
            int notificationPriority = 3;
            if (priority != null) {
                if (priority.equalsIgnoreCase("High")) {
                    notificationPriority = 4;
                } else if (priority.equalsIgnoreCase("Low")) {
                    notificationPriority = 3;
                }
            }
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"title", notificationPriority);
            channel.setDescription("body");
            assert (mNotificationManager != null);
            mNotificationManager.createNotificationChannel(channel);
            notificationBuilder.setChannelId(channelId);
        } else if (priority != null && Build.VERSION.SDK_INT >= 16) {
            if (priority.equalsIgnoreCase("High")) {
                notificationBuilder.setPriority(1);
            } else if (priority.equalsIgnoreCase("Low")) {
                notificationBuilder.setPriority(-1);
            }
        }
        if (pendingIntent != null) {
            notificationBuilder.setContentIntent(pendingIntent);
        }
        if (data.get("light_up_screen") != null && data.get("light_up_screen").equalsIgnoreCase("true") && !(isScreenOn = (pm = (PowerManager)this.getApplicationContext().getSystemService("power")).isScreenOn())) {
            PowerManager.WakeLock wl = pm.newWakeLock(805306394, "MyLock");
            wl.acquire(10000L);
            PowerManager.WakeLock wl_cpu = pm.newWakeLock(1, "MyCpuLock");
            wl_cpu.acquire(10000L);
        }
        if (data.get("btn1_enabled") != null && data.get("btn1_enabled").equalsIgnoreCase("true") && Build.VERSION.SDK_INT >= 23) {
            String btn1Title = "";
            String btn1Action = "close";
            String btn1FinalAddress = "";
            String btn1Content = "";
            int btn1Icon = 0;
            int btn1Id = 0;
            if (data.get("btn1_title") != null) {
                btn1Title = data.get("btn1_title");
            }
            if (data.get("btn1_icon") != null) {
                int iconCode = 0;
                try {
                    iconCode = Integer.valueOf(data.get("btn1_icon"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                btn1Icon = IconHandler.getNotificationButtonIcon(iconCode);
            }
            if (data.get("btn1_id") != null) {
                btn1Id = Integer.valueOf(data.get("btn1_id"));
            }
            if (data.get("btn1_action") != null) {
                btn1Action = data.get("btn1_action");
            }
            if (data.get("btn1_final_address") != null) {
                btn1FinalAddress = data.get("btn1_final_address");
            }
            if (data.get("btn1_content") != null) {
                btn1Content = data.get("btn1_content");
            }
            PendingIntent buttonPendingIntent = this.setNotificationAction(btn1Action, Integer.parseInt(notificationId), btn1FinalAddress, btn1Content, messageId, Parameter.BUTTON_CLICK_TYPE.getValue(), btn1Id);
            notificationBuilder.addAction(btn1Icon, (CharSequence)btn1Title, buttonPendingIntent);
        }
        if (data.get("btn2_enabled") != null && data.get("btn2_enabled").equalsIgnoreCase("true") && Build.VERSION.SDK_INT >= 23) {
            String btn2Title = "";
            String btn2Action = "close";
            String btn2FinalAddress = "";
            String btn2Content = "";
            int btn2Icon = 0;
            int btn2Id = 0;
            if (data.get("btn2_title") != null) {
                btn2Title = data.get("btn2_title");
            }
            if (data.get("btn2_icon") != null) {
                int iconCode = 0;
                try {
                    iconCode = Integer.valueOf(data.get("btn2_icon"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                btn2Icon = IconHandler.getNotificationButtonIcon(iconCode);
            }
            if (data.get("btn2_id") != null) {
                btn2Id = Integer.valueOf(data.get("btn2_id"));
            }
            if (data.get("btn2_action") != null) {
                btn2Action = data.get("btn2_action");
            }
            if (data.get("btn2_final_address") != null) {
                btn2FinalAddress = data.get("btn2_final_address");
            }
            if (data.get("btn2_content") != null) {
                btn2Content = data.get("btn2_content");
            }
            PendingIntent buttonPendingIntent = this.setNotificationAction(btn2Action, Integer.parseInt(notificationId), btn2FinalAddress, btn2Content, messageId, Parameter.BUTTON_CLICK_TYPE.getValue(), btn2Id);
            notificationBuilder.addAction(btn2Icon, (CharSequence)btn2Title, buttonPendingIntent);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (data.get("icon") == null) {
                if (data.get("image") != null) {
                    queue = Volley.newRequestQueue((Context)this.getApplicationContext());
                    imageRequest = new ImageRequest(data.get("image"), (Response.Listener)new Response.Listener<Bitmap>(){

                        public void onResponse(Bitmap response) {
                            if (response != null && Build.VERSION.SDK_INT >= 16) {
                                Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle().bigPicture(response).setBigContentTitle((CharSequence)data.get("title")).setSummaryText((CharSequence)data.get("body"));
                                notificationBuilder.setStyle((Notification.Style)bigPictureStyle);
                                notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                                notificationBuilder.setDefaults(2);
                                notificationBuilder.setLights(-16776961, 1000, 300);
                                NotificationManager notificationManager = (NotificationManager)NajvaMessagingService.this.getSystemService("notification");
                                assert (notificationManager != null);
                                if (Build.VERSION.SDK_INT < 16) {
                                    notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                                } else {
                                    notificationManager.notify(messageId, 0, notificationBuilder.build());
                                }
                            }
                        }
                    }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                            VolleyLog.wtf((String)error.getMessage(), (Object[])new Object[]{"utf-8"});
                        }
                    });
                    imageRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 3, 1.0f));
                    queue.add((Request)imageRequest);
                } else {
                    notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                    notificationBuilder.setDefaults(2);
                    notificationBuilder.setLights(-16776961, 1000, 300);
                    notificationManager = (NotificationManager)this.getSystemService("notification");
                    assert (notificationManager != null);
                    if (Build.VERSION.SDK_INT < 16) {
                        notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                    } else {
                        notificationManager.notify(messageId, 0, notificationBuilder.build());
                    }
                }
            } else if (data.get("image") == null) {
                queue = Volley.newRequestQueue((Context)this.getApplicationContext());
                imageRequest = new ImageRequest(data.get("icon"), (Response.Listener)new Response.Listener<Bitmap>(){

                    public void onResponse(Bitmap response) {
                        if (response != null) {
                            notificationBuilder.setLargeIcon(response);
                            notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                            notificationBuilder.setDefaults(2);
                            notificationBuilder.setLights(-16776961, 1000, 300);
                            NotificationManager notificationManager = (NotificationManager)NajvaMessagingService.this.getSystemService("notification");
                            assert (notificationManager != null);
                            if (Build.VERSION.SDK_INT < 16) {
                                notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                            } else {
                                notificationManager.notify(messageId, 0, notificationBuilder.build());
                            }
                        }
                    }
                }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        VolleyLog.wtf((String)error.getMessage(), (Object[])new Object[]{"utf-8"});
                    }
                });
                imageRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 3, 1.0f));
                queue.add((Request)imageRequest);
            } else {
                queue = Volley.newRequestQueue((Context)this.getApplicationContext());
                imageRequest = new ImageRequest(data.get("icon"), (Response.Listener)new Response.Listener<Bitmap>(){

                    public void onResponse(final Bitmap iconResponse) {
                        if (iconResponse != null) {
                            RequestQueue queue = Volley.newRequestQueue((Context)NajvaMessagingService.this.getApplicationContext());
                            ImageRequest imageRequest = new ImageRequest((String)data.get("image"), (Response.Listener)new Response.Listener<Bitmap>(){

                                public void onResponse(Bitmap imageResponse) {
                                    if (imageResponse != null && Build.VERSION.SDK_INT >= 16) {
                                        Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle().bigPicture(imageResponse).setBigContentTitle((CharSequence)data.get("title")).setSummaryText((CharSequence)data.get("body"));
                                        notificationBuilder.setLargeIcon(iconResponse);
                                        notificationBuilder.setStyle((Notification.Style)bigPictureStyle);
                                        notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                                        notificationBuilder.setDefaults(2);
                                        notificationBuilder.setLights(-16776961, 1000, 300);
                                        NotificationManager notificationManager = (NotificationManager)NajvaMessagingService.this.getSystemService("notification");
                                        assert (notificationManager != null);
                                        if (Build.VERSION.SDK_INT < 16) {
                                            notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                                        } else {
                                            notificationManager.notify(messageId, 0, notificationBuilder.build());
                                        }
                                    }
                                }
                            }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                                public void onErrorResponse(VolleyError error) {
                                    VolleyLog.wtf((String)error.getMessage(), (Object[])new Object[]{"utf-8"});
                                }
                            });
                            imageRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 3, 1.0f));
                            queue.add((Request)imageRequest);
                        }
                    }
                }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        VolleyLog.wtf((String)error.getMessage(), (Object[])new Object[]{"utf-8"});
                    }
                });
                imageRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 3, 1.0f));
                queue.add((Request)imageRequest);
            }
        } else if (data.get("icon") != null) {
            queue = Volley.newRequestQueue((Context)this.getApplicationContext());
            imageRequest = new ImageRequest(data.get("icon"), (Response.Listener)new Response.Listener<Bitmap>(){

                public void onResponse(Bitmap response) {
                    if (response != null) {
                        notificationBuilder.setLargeIcon(response);
                        notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                        notificationBuilder.setDefaults(2);
                        notificationBuilder.setLights(-16776961, 1000, 300);
                        NotificationManager notificationManager = (NotificationManager)NajvaMessagingService.this.getSystemService("notification");
                        assert (notificationManager != null);
                        if (Build.VERSION.SDK_INT < 16) {
                            notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
                        } else {
                            notificationManager.notify(messageId, 0, notificationBuilder.build());
                        }
                    }
                }
            }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    VolleyLog.wtf((String)error.getMessage(), (Object[])new Object[]{"utf-8"});
                }
            });
            imageRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 3, 1.0f));
            queue.add((Request)imageRequest);
        } else {
            notificationBuilder.setSmallIcon(R.drawable.notif_icon);
            notificationBuilder.setDefaults(2);
            notificationBuilder.setLights(-16776961, 1000, 300);
            notificationManager = (NotificationManager)this.getSystemService("notification");
            assert (notificationManager != null);
            if (Build.VERSION.SDK_INT < 16) {
                notificationManager.notify(messageId, 0, notificationBuilder.getNotification());
            } else {
                notificationManager.notify(messageId, 0, notificationBuilder.build());
            }
        }
    }

    public void onNewToken(String token) {
        this.updateSubscriptionFile(this.getApplicationContext());
        Najva.getInstance().updateSubscriber(token);
    }

    private void updateSubscriptionFile(Context context) {
        File path = this.getPath(context);
        try {
            File file = new File(path, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("0");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getWebsiteInfo(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() < 2) {
                records.set(0, "0");
                records.set(1, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return records;
    }

    public File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private PendingIntent setNotificationAction(String notificationAction, int notificationId, String finalAddress, String notificationContent, String messageId, String clickType, int button_id) {
        Class<?> act = null;
        try {
            act = Class.forName("com.najva.najvasdk.Activity.NajvaActivity");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Intent notificationIntent = new Intent(this.getApplicationContext(), act);
        notificationIntent.putExtra("message_id", messageId);
        notificationIntent.putExtra("onclick_action", notificationAction);
        notificationIntent.putExtra("final_address", finalAddress);
        notificationIntent.putExtra("notification_id", notificationId);
        notificationIntent.putExtra("website_info", this.getWebsiteInfo(this.getApplicationContext()));
        notificationIntent.putExtra("notification_content", notificationContent);
        notificationIntent.putExtra("click_type", clickType);
        if (button_id > 0) {
            notificationIntent.putExtra("button_id", button_id);
        }
        if (notificationIntent != null) {
            int dummyUniqueInt = new Random().nextInt(543254);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)dummyUniqueInt, (Intent)notificationIntent, (int)0x10000000);
            return pendingIntent;
        }
        return null;
    }
}

