/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.MetaFormRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InstallPackageReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String packageName = intent.getData().getEncodedSchemeSpecificPart();
        PackageManager packageManager = context.getPackageManager();
        String appLabel = "";
        try {
            appLabel = (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, 128));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.addPackageInfoRequest(context, packageName, appLabel);
    }

    private void addPackageInfoRequest(final Context context, final String packageName, final String appLabel) {
        RequestQueue queue = Volley.newRequestQueue((Context)context);
        MetaFormRequest postRequest = new MetaFormRequest(1, ApiInfo.CHANGE_DEVICE_INFO.getValue(), (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        }){

            protected Map<String, String> getParams() {
                return InstallPackageReceiver.this.getPackageInfoParams(packageName, appLabel);
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = super.getHeaders();
                if (headers == null || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", InstallPackageReceiver.this.getCookie(context));
                return headers;
            }
        };
        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
        queue.add((Request)postRequest);
    }

    private HashMap<String, String> getPackageInfoParams(String packageName, String appLabel) {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedAppLable = appLabel;
        try {
            encodedAppLable = URLEncoder.encode(encodedAppLable, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        params.put("operation", "add");
        params.put("package_name", packageName);
        params.put("app_label", encodedAppLable);
        return params;
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }
}

