/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.MetaFormRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChangeSimcardReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String newOperator = this.getSimOperatorName(context);
        if (!newOperator.equalsIgnoreCase(this.getLastSimcardOperator(context))) {
            this.saveNewOperator(context);
            this.sendNewOperatorToServer(context);
        }
    }

    private String getSimOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        assert (manager != null);
        return manager.getSimOperatorName();
    }

    private String getLastSimcardOperator(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void saveNewOperator(Context context) {
        File path = this.getPath(context);
        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write(this.getSimOperatorName(context));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private void sendNewOperatorToServer(final Context context) {
        RequestQueue queue = Volley.newRequestQueue((Context)context);
        MetaFormRequest postRequest = new MetaFormRequest(1, ApiInfo.UPDATE_OPERATOR.getValue(), (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        }){

            protected Map<String, String> getParams() {
                return ChangeSimcardReceiver.this.getOperatorParams(ChangeSimcardReceiver.this.getSimOperatorName(context));
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = super.getHeaders();
                if (headers == null || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", ChangeSimcardReceiver.this.getCookie(context));
                return headers;
            }
        };
        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
        queue.add((Request)postRequest);
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HashMap<String, String> getOperatorParams(String operator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("operator", operator);
        return params;
    }
}

