/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Class;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Header;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.najva.najvasdk.Class.NajvaUserHandler;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.FileSystem;
import com.najva.najvasdk.Utils.MetaFormRequest;
import com.najva.najvasdk.Utils.MetaJsonRequest;
import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class Najva {
    private static Najva najva;
    private String token;
    private String apiKey;
    private int websiteId;
    private int campaignId;
    private boolean location;
    private Context context;
    private FusedLocationProviderClient fusedLocationClient;
    private NajvaUserHandler najvaUserHandler;

    public static void initialize(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        Najva.getInstance().init(context, campaignId, websiteId, apiKey, location);
    }

    public static void setUserHandler(NajvaUserHandler najvaUserHandler) {
        Najva.getInstance().setNajvaUserHandler(najvaUserHandler);
    }

    public static Najva getInstance() {
        if (najva == null) {
            najva = new Najva();
        }
        return najva;
    }

    private void init(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        this.apiKey = apiKey;
        this.websiteId = websiteId;
        this.campaignId = campaignId;
        this.location = location;
        this.context = context;
        this.fusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)this.context);
        this.najvaUserHandler = new NajvaUserHandler();
        Sentry.init((String)"https://757d7eb9756f491cb7eb7dd690c4224e:67f87d2511954d6e8236a431bd0f7fdd@sentry.yektanet.com/38");
        FirebaseOptions options = new FirebaseOptions.Builder().setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()).setApiKey(Parameter.FIREBASE_API_KEY.getValue()).setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()).build();
        try {
            FirebaseApp.getInstance((String)this.apiKey);
        }
        catch (IllegalStateException e) {
            FirebaseApp.initializeApp((Context)context, (FirebaseOptions)options, (String)this.apiKey);
        }
        this.saveWebsiteInfo();
        if (this.location) {
            try {
                this.setLocationRequest();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.checkAppVersion();
        this.updateLastLogin();
    }

    private void setNajvaUserHandler(NajvaUserHandler najvaUserHandler) {
        this.najvaUserHandler = najvaUserHandler;
    }

    public void updateSubscriber(String token) {
        this.token = token;
        try {
            this.addSubscriberToCampaign(this.context, this.getParams(), this.location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addSubscriberToCampaign(final Context context, final HashMap<String, String> params, final boolean location) throws IOException {
        if (this.isSubscribed()) {
            System.out.println("already subscribed!");
            return;
        }
        RequestQueue queue = Volley.newRequestQueue((Context)context);
        MetaFormRequest postRequest = new MetaFormRequest(1, ApiInfo.ADD_SUBSCRIBER_URL.getValue(), (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Najva.this.updateSubscriptionFile(context);
                if (location) {
                    try {
                        Najva.this.setLocationRequest();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    JSONObject jsonObj = new JSONObject(response);
                    String cookieToken = (String)jsonObj.get("cookie_token");
                    Najva.getInstance().handleNajvaUser(cookieToken);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                Najva.this.createDeviceInfoRequest();
                Najva.this.saveSimOperator();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        }){

            protected Map<String, String> getParams() {
                return params;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = super.getHeaders();
                if (headers == null || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", Najva.this.getCookie());
                return headers;
            }

            @Override
            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                for (Header h : response.allHeaders) {
                    if (!h.getName().equalsIgnoreCase("Set-Cookie")) continue;
                    Najva.this.saveCookie(h.getValue());
                }
                return super.parseNetworkResponse(response);
            }
        };
        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
        queue.add((Request)postRequest);
    }

    private void setLocationRequest() throws IOException {
        if (!this.isSubscribed()) {
            return;
        }
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)1);
        } else {
            if (!this.checkLocationStatus()) {
                return;
            }
            this.fusedLocationClient.getLastLocation().addOnSuccessListener((Activity)this.context, (OnSuccessListener)new OnSuccessListener<Location>(){

                public void onSuccess(Location currentLocation) {
                    if (currentLocation != null) {
                        RequestQueue queue = Volley.newRequestQueue((Context)Najva.this.context);
                        JSONObject jsonBody = new JSONObject((Map)Najva.this.getLocationParams(currentLocation));
                        MetaJsonRequest postRequest = new MetaJsonRequest(ApiInfo.SET_LOCATION_URL.getValue(), jsonBody, (Response.Listener)new Response.Listener<JSONObject>(){

                            public void onResponse(JSONObject response) {
                                Najva.this.saveLastLocationTime();
                            }
                        }, new Response.ErrorListener(){

                            public void onErrorResponse(VolleyError error) {
                            }
                        }){

                            public Map<String, String> getHeaders() throws AuthFailureError {
                                HashMap<String, String> headers = super.getHeaders();
                                if (headers == null || headers.equals(Collections.emptyMap())) {
                                    headers = new HashMap<String, String>();
                                }
                                headers.put("Cookie", Najva.this.getCookie());
                                headers.put("Content-Type", "application/json");
                                return headers;
                            }

                            @Override
                            protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
                                try {
                                    Map headers = response.headers;
                                    String cookies = null;
                                    try {
                                        cookies = (String)headers.get("Set-Cookie");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (cookies != null) {
                                        Najva.this.saveCookie(cookies);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return super.parseNetworkResponse(response);
                            }
                        };
                        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
                        queue.add((Request)postRequest);
                    }
                }
            });
        }
    }

    private void createDeviceInfoRequest() {
        RequestQueue queue = Volley.newRequestQueue((Context)this.context);
        MetaFormRequest postRequest = new MetaFormRequest(1, ApiInfo.CREATE_DEVICE_INFO.getValue(), (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        }){

            protected Map<String, String> getParams() {
                return Najva.this.getDeviceInfoParams();
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = super.getHeaders();
                if (headers == null || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", Najva.this.getCookie());
                return headers;
            }
        };
        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
        queue.add((Request)postRequest);
    }

    private int responseStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token_id", this.token);
        params.put("api_key", this.apiKey);
        params.put("website_id", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));
        return params;
    }

    private HashMap<String, String> getLocationParams(Location locationObject) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (locationObject != null) {
            params.put("latitude", String.valueOf(locationObject.getLatitude()));
            params.put("longitude", String.valueOf(locationObject.getLongitude()));
            params.put("altitude", String.valueOf(locationObject.getAltitude()));
            params.put("accuracy", String.valueOf(locationObject.getAccuracy()));
        }
        return params;
    }

    private HashMap<String, String> getDeviceInfoParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sim_operator_name", this.getSimOperatorName());
        params.put("device_model", Najva.getDeviceModel());
        params.put("android_version", this.getAndroidVersion());
        params.put("android_id", this.getAndroidId());
        String encodedPackageInfo = this.getPackageInfo();
        try {
            encodedPackageInfo = URLEncoder.encode(encodedPackageInfo, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        params.put("android_package_info", encodedPackageInfo);
        params.put("manufacturer", Build.MANUFACTURER);
        params.put("app_version", this.getAppVersion());
        return params;
    }

    private boolean isSubscribed() {
        String value = FileSystem.readFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
        return value != null && Integer.valueOf(value) == 1;
    }

    private void updateSubscriptionFile(Context context) {
        ArrayList<String> values = new ArrayList<String>();
        values.add("1");
        FileSystem.saveToFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue(), values);
    }

    private String getCookie() {
        return FileSystem.readFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
    }

    private void saveCookie(String cookies) {
        if (cookies != null && cookies.contains("najva_token")) {
            int idx = cookies.indexOf("najva_token=");
            int offset_idx = 0;
            while (cookies.charAt(idx + offset_idx) != ';') {
                ++offset_idx;
            }
            String najva_token = cookies.substring(idx, idx + offset_idx + 1);
            this.updateCookie(najva_token);
        }
    }

    private void updateCookie(String cookie) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(cookie);
        FileSystem.saveToFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue(), values);
    }

    private void saveLastLocationTime() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue(), values);
    }

    private boolean checkLocationStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(12L)).before(lastDate)) {
                return false;
            }
        }
        return true;
    }

    private void saveWebsiteInfo() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(this.websiteId));
        values.add(System.getProperty("line.separator"));
        values.add(this.apiKey);
        FileSystem.saveToFile(this.context, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue(), values);
    }

    private void saveSimOperator() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getSimOperatorName());
        FileSystem.saveToFile(this.context, Parameter.OPERATOR_NAME_FILE_NAME.getValue(), values);
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private static String getDeviceModel() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    private String getAndroidId() {
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    private String getSimOperatorName() {
        TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
        assert (manager != null);
        return manager.getSimOperatorName();
    }

    private String getAndroidVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    private String getPackageInfo() {
        StringBuilder jsonResponse = new StringBuilder("[");
        PackageManager packageManager = this.context.getPackageManager();
        List installedApplications = packageManager.getInstalledApplications(128);
        for (ApplicationInfo appInfo : installedApplications) {
            jsonResponse.append("{\"package_name\": ").append("\"").append(appInfo.packageName).append("\"").append(", ").append("\"app_label\": ").append("\"").append(appInfo.loadLabel(packageManager)).append("\"").append("}, ");
        }
        if (jsonResponse.length() > 1) {
            jsonResponse = new StringBuilder(jsonResponse.substring(0, jsonResponse.length() - 2));
        }
        jsonResponse.append("]");
        return jsonResponse.toString();
    }

    private String getAppVersion() {
        String version = "";
        try {
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            version = pInfo.versionName;
            System.out.println(version == null);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    private void checkAppVersion() {
        String lastVersion = this.getLastAppVersionSaved();
        final String currentVersion = this.getAppVersion();
        if (lastVersion == null) {
            this.saveLastAppVersion();
        } else if (!lastVersion.equalsIgnoreCase(currentVersion)) {
            RequestQueue queue = Volley.newRequestQueue((Context)this.context);
            MetaFormRequest postRequest = new MetaFormRequest(1, ApiInfo.UPDATE_OPERATOR.getValue(), (Response.Listener)new Response.Listener<String>(){

                public void onResponse(String response) {
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                }
            }){

                protected Map<String, String> getParams() {
                    return Najva.this.getAppVersionParams(currentVersion);
                }

                public Map<String, String> getHeaders() throws AuthFailureError {
                    HashMap<String, String> headers = super.getHeaders();
                    if (headers == null || headers.equals(Collections.emptyMap())) {
                        headers = new HashMap<String, String>();
                    }
                    headers.put("Cookie", Najva.this.getCookie());
                    return headers;
                }
            };
            postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
            queue.add((Request)postRequest);
        }
    }

    private void saveLastAppVersion() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getAppVersion());
        FileSystem.saveToFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue(), values);
    }

    private String getLastAppVersionSaved() {
        String val = FileSystem.readFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue());
        return val;
    }

    private HashMap<String, String> getAppVersionParams(String newVersion) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_version", newVersion);
        return params;
    }

    private void updateLastLogin() {
        if (!this.checkLastLoginTimeStatus() || !this.isSubscribed()) {
            return;
        }
        StringBuilder currentUrl = new StringBuilder(ApiInfo.API_CURRENT_USER.getValue() + "?");
        HashMap<String, String> lastUpdateTimeParams = this.getLastUpdateTimeParams();
        for (String key : lastUpdateTimeParams.keySet()) {
            currentUrl.append(key).append("=").append(lastUpdateTimeParams.get(key)).append("&");
        }
        if (lastUpdateTimeParams.size() > 0) {
            currentUrl.deleteCharAt(currentUrl.length() - 1);
        }
        String url = currentUrl.toString();
        RequestQueue queue = Volley.newRequestQueue((Context)this.context);
        MetaFormRequest postRequest = new MetaFormRequest(0, url, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Najva.this.saveLastLoginTime();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = super.getHeaders();
                if (headers == null || headers.equals(Collections.emptyMap())) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Cookie", Najva.this.getCookie());
                return headers;
            }

            @Override
            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                Map headers = response.headers;
                String cookies = null;
                try {
                    cookies = (String)headers.get("Set-Cookie");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cookies != null) {
                    Najva.this.saveCookie(cookies);
                }
                return super.parseNetworkResponse(response);
            }
        };
        postRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(60000, 3, 1.0f));
        queue.add((Request)postRequest);
    }

    private HashMap<String, String> getLastUpdateTimeParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("update_time", "1");
        params.put("get_token", "1");
        params.put("api_key", this.apiKey);
        params.put("website", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));
        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return params;
    }

    private void saveLastLoginTime() {
        ArrayList<String> values = new ArrayList<String>();
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        values.add(formatter.format(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue(), values);
    }

    private boolean checkLastLoginTimeStatus() {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String value = FileSystem.readFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue());
        if (value != null) {
            try {
                Date lastDate = formatter.parse(value);
                if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24L)).before(lastDate) && lastDate.getDay() == new Date(System.currentTimeMillis()).getDay()) {
                    return false;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void handleNajvaUser(String token) {
        this.najvaUserHandler.najvaUserSubscribed(token);
    }
}

