package com.najva.najvasdk.Utils;

import android.support.annotation.Nullable;

import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.toolbox.StringRequest;

import java.util.Map;


public class MetaFormRequest extends StringRequest {
    private String cookies;

    public MetaFormRequest(int method, String url, Response.Listener<String> listener, @Nullable Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
    }

    public MetaFormRequest(String url, Response.Listener<String> listener, @Nullable Response.ErrorListener errorListener) {
        super(url, listener, errorListener);
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        Map<String, String> headers = response.headers;
        try {
            cookies = headers.get("Set-Cookie");
        } catch (Exception ignored){}

        return super.parseNetworkResponse(response);
    }

    public String getCookies(){
        return this.cookies;
    }
}
