package com.najva.najvasdk.Utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * Created by sina on 9/18/2018.
 */
public class HttpHandleResponse {

    public static void sendRequest(final String method, final String host, final String url, final String username,
                                   final String password, final HashMap<String, String> params, final String contenType, final String cookie, final IResponse iResponse){


        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                String urlPath = url.replace(" ", "+");


                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpGet httpGet = null;
                HttpPost httpPost = null;

                UsernamePasswordCredentials defaultcreds = null;
                if (username != null && password != null) {
                    defaultcreds = new UsernamePasswordCredentials(username, password);
                }

                if (method.equals("GET")){
                    httpGet = new HttpGet(urlPath);
                    if (defaultcreds != null) {
                        httpGet.addHeader(BasicScheme.authenticate(defaultcreds, "UTF-8", false));
                    }
                    httpGet.setHeader("Content-Type", "application/json");

                    if (cookie != null){
                        httpGet.setHeader("Cookie", cookie);
                    }

                }else if (method.equals("POST")){
                    httpPost = new HttpPost(urlPath);

                    if (contenType == "application/json"){

                        if (params != null){

                            String bodyJson = "{";
                            for (String key: params.keySet()){
                                bodyJson += "\"" + key + "\": " + "\"" + params.get(key) + "\"";
                                bodyJson += ", ";
                            }
                            if (bodyJson.length() > 1) {
                                bodyJson = bodyJson.substring(0, bodyJson.length() - 2);
                            }
                            bodyJson += "}";

                            StringEntity entity = null;
                            try {
                                entity = new StringEntity(bodyJson);
                            } catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            httpPost.setEntity(entity);
                        }

                    }else if (contenType == "application/x-www-form-urlencoded"){

                        if (params != null){
                            List<NameValuePair> pairs = new ArrayList<NameValuePair>();
                            for (String key: params.keySet()){
                                pairs.add(new BasicNameValuePair(key, params.get(key)));
                            }
                            try {
                                httpPost.setEntity(new UrlEncodedFormEntity(pairs));
                            } catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                    }


                    if (defaultcreds != null) {
                        httpPost.addHeader(BasicScheme.authenticate(defaultcreds, "UTF-8", false));
                    }

                    if (cookie != null){
                        httpPost.setHeader("Cookie", cookie);
                    }

                    httpPost.addHeader("content-type", contenType);
                }

                if (defaultcreds != null) {
                    httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, AuthScope.ANY_PORT), defaultcreds);
                }

                try {

                    HttpResponse response = null;
                    if (method.equals("GET")){
                        response = httpClient.execute(httpGet);
                    }else if (method.equals("POST")){
                        response = httpClient.execute(httpPost);
                    }
                    assert response != null;
                    InputStream entity = response.getEntity().getContent();

                    BufferedReader bR = new BufferedReader(new InputStreamReader(entity));
                    String line = "";

                    StringBuilder responseStrBuilder = new StringBuilder();
                    while((line =  bR.readLine()) != null){
                        responseStrBuilder.append(line);
                    }
                    entity.close();

                    Header [] headers = response.getAllHeaders();
                    for (Header header : headers) {
                        System.out.println(" --> " + header.getName() + ":" + header.getValue());
                    }

                    for (Header h: response.getHeaders("Set-Cookie")){
                        System.out.println("cookie: " + h.getValue().subSequence(h.getValue().indexOf("=") + 1, h.getValue().indexOf(";") + 1));
                    }

                    iResponse.handleRequest(response, responseStrBuilder.toString());
                }catch (Exception ignored){}
            }
        });
        thread.start();
    }

    public static void getBitmapFromURL(final String src, final IBitmapResponse iBitmapResponse) {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {

                if (src == null){
                    iBitmapResponse.handleBitmapRequest(null);
                }

                try {
                    HttpGet httpRequest = new HttpGet(URI.create(src.toString()));
                    DefaultHttpClient httpclient = new DefaultHttpClient();
                    HttpResponse response = (HttpResponse) httpclient.execute(httpRequest);
                    HttpEntity entity = response.getEntity();

                    BufferedHttpEntity bufHttpEntity = new BufferedHttpEntity(entity);
                    Bitmap  myBitmap = BitmapFactory.decodeStream(bufHttpEntity.getContent());

                    httpRequest.abort();

                    iBitmapResponse.handleBitmapRequest(myBitmap);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();


    }
}