package com.najva.najvasdk.Activity;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.R;
//import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;
import com.najva.najvasdk.Utils.MetaFormRequest;
import com.najva.najvasdk.Utils.Network;

import org.apache.http.HttpResponse;
import org.json.JSONException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NajvaActivity extends AppCompatActivity {

    @Override
    protected void onNewIntent (Intent intent) {
        setIntent(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_najva1237121793087);

        String notificationAction = null;
        String finalAddress = "";
        int notificationId = 0;
        String messageId = "";
        String clickType = null;
        int buttonId = -1;

        try {
            buttonId = this.getIntent().getExtras().getInt("button_id");
        }catch (NullPointerException ignored){}

        try {
            clickType = this.getIntent().getExtras().getString("click_type");
        }catch (NullPointerException ignored){}

        try {
            messageId = this.getIntent().getExtras().getString("message_id");
        }catch (NullPointerException ignored){}

        try {
            notificationAction = this.getIntent().getStringExtra("onclick_action");
        } catch (NullPointerException ignored){}

        try{
            finalAddress = this.getIntent().getExtras().getString("final_address");
        } catch (NullPointerException ignored){}

        try{
            notificationId = this.getIntent().getExtras().getInt("notification_id");
        } catch (NullPointerException ignored){}

        final ArrayList<String> websiteInfo = this.getIntent().getExtras().getStringArrayList("website_info");

        Intent notificationIntent = null;

        assert notificationAction != null;
        switch (notificationAction){
            case "open-link":{
                try {
                    finalAddress = java.net.URLDecoder.decode(finalAddress, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
//                String url = ApiInfo.REDIRECT_CLICK.getValue() + "?notification_id=" + notificationId + "&website_id=" + websiteInfo.get(0) + "&api_key=" + websiteInfo.get(1) + "&next=" + finalAddress;
                String url = finalAddress;
                notificationIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                startActivity(notificationIntent);
                this.finish();

                break;
            }

            case "open-app":{
                String packageName = getApplicationContext().getPackageName();
                Intent launchIntent = getApplicationContext().getPackageManager().getLaunchIntentForPackage(packageName);
                String className = launchIntent.getComponent().getClassName();

                Class<?> act = null;
                try {
                    act = Class.forName(className);
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                notificationIntent = new Intent(getApplicationContext(), act);
                break;
            }

            case "open-activity":{
                Class<?> act = null;
                try {
                    act = Class.forName(finalAddress);
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                notificationIntent = new Intent(getApplicationContext(), act);
                break;
            }

            case "open-call":{
                notificationIntent = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:" + finalAddress));
                break;
            }

            case "open-sms":{
                String content = "";
                try{
                    content = this.getIntent().getExtras().getString("notification_content");
                } catch (NullPointerException ignored){}

                notificationIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("sms:" + finalAddress));
                notificationIntent.putExtra("sms_body", content);
                break;
            }

            case "open-telegram-channel":{
                notificationIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("tg://resolve?domain=" + finalAddress));
                break;
            }

            case "join-telegram-channel": {
                notificationIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(finalAddress));
                break;
            }

        }

        if (notificationIntent != null){
            if (clickType != null && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue())){
                NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                assert notificationManager != null;
                notificationManager.cancel(messageId, 0);
            }
        }

        assert notificationIntent != null;
        notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(notificationIntent);


        if (Network.isConnected(this)) {
            if (clickType != null && clickType.equalsIgnoreCase(Parameter.ORIGINAL_CLICK_TYPE.getValue())) {

                RequestQueue queue = Volley.newRequestQueue(this);
                final int finalNotificationId1 = notificationId;
                MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.CLICK_LOG.getValue(),
                        new Response.Listener<String>()
                        {
                            @Override
                            public void onResponse(String response) {
                            }
                        },
                        new Response.ErrorListener()
                        {
                            @Override
                            public void onErrorResponse(VolleyError error) {
                            }
                        }
                ) {
                    @Override
                    protected Map<String, String> getParams()
                    {
                        return getClickParams(websiteInfo.get(1), websiteInfo.get(0), finalNotificationId1);
                    }

                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        Map<String, String> headers = super.getHeaders();

                        if (headers == null
                                || headers.equals(Collections.emptyMap())) {
                            headers = new HashMap<String, String>();
                        }
                        headers.put("Cookie", getCookie());

                        return headers;
                    }
                };
                postRequest.setRetryPolicy(new DefaultRetryPolicy(
                        60 * 1000,
                        3,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                queue.add(postRequest);

//                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CLICK_LOG.getValue(),
//                        null, null, getClickParams(websiteInfo.get(1), websiteInfo.get(0), notificationId), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                            @Override
//                            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                            }
//                        });
            } else if (clickType != null && buttonId > 0 && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue())) {

                RequestQueue queue = Volley.newRequestQueue(this);
                final int finalNotificationId = notificationId;
                final int finalButtonId = buttonId;
                MetaFormRequest postRequest = new MetaFormRequest(Request.Method.POST, ApiInfo.BUTTON_CLICK_LOG.getValue(),
                        new Response.Listener<String>()
                        {
                            @Override
                            public void onResponse(String response) {
                            }
                        },
                        new Response.ErrorListener()
                        {
                            @Override
                            public void onErrorResponse(VolleyError error) {
                            }
                        }
                ) {
                    @Override
                    protected Map<String, String> getParams()
                    {
                        return getButtonClickLog(websiteInfo.get(1), websiteInfo.get(0), finalNotificationId, finalButtonId);
                    }

                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        Map<String, String> headers = super.getHeaders();

                        if (headers == null
                                || headers.equals(Collections.emptyMap())) {
                            headers = new HashMap<String, String>();
                        }
                        headers.put("Cookie", getCookie());

                        return headers;
                    }
                };
                postRequest.setRetryPolicy(new DefaultRetryPolicy(
                        60 * 1000,
                        3,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
                queue.add(postRequest);
//
//                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.BUTTON_CLICK_LOG.getValue(),
//                        null, null, getButtonClickLog(websiteInfo.get(1), websiteInfo.get(0), notificationId, buttonId), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
//                            @Override
//                            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
//                            }
//                        });

            }
        } else {
            if (clickType != null && clickType.equalsIgnoreCase(Parameter.ORIGINAL_CLICK_TYPE.getValue())) {
                saveClickLog(websiteInfo.get(1), websiteInfo.get(0), notificationId);
            } else if (clickType != null && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue())) {
                if (buttonId > 0) {
                    saveButtonClickLog(websiteInfo.get(1), websiteInfo.get(0), notificationId, buttonId);
                }
            }
        }

        this.finish();
    }


    private HashMap<String, String> getClickParams(String apiKey, String websiteId, int notificationId){
        HashMap<String, String> params = new HashMap<>();

        params.put("website_id", websiteId);
        params.put("api_key", apiKey);
        params.put("notification_id", String.valueOf(notificationId));

        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            } catch (Exception ignored) {}
        }

        return params;
    }

    private HashMap<String, String> getButtonClickLog(String apiKey, String websiteId, int notificationId, int buttonId){
        HashMap<String, String> params = new HashMap<>();

        params.put("website_id", websiteId);
        params.put("api_key", apiKey);
        params.put("notification_id", String.valueOf(notificationId));
        params.put("button_id", String.valueOf(buttonId));

        return params;
    }

    private String getCookie(){
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(getApplicationContext());

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private void saveClickLog(String apiKey, String websiteId, int notificationId){
        File path = getPath(getApplicationContext());

        try {
            File file = new File(path, Parameter.CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file, true);

            // file write format:
            // api_key:website_id:notification_id
            writer.write(apiKey + ":" + websiteId + ":" + String.valueOf(notificationId));
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveButtonClickLog(String apiKey, String websiteId, int notifcationId, int buttonId) {
        File path = getPath(getApplicationContext());

        try {
            File file =  new File(path, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file, true);

            //file write format:
            // api_key:website_id:notification:id:button_id
            writer.write(apiKey + ":" + websiteId + ":" + String.valueOf(notifcationId) + ":" + String.valueOf(buttonId));
            writer.flush();
            writer.close();
        }catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context){
        File path = new File(getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }
}
