/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Activity;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.R;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;
import com.najva.najvasdk.Utils.Network;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.json.JSONException;

public class NajvaActivity
extends AppCompatActivity {
    protected void onNewIntent(Intent intent) {
        this.setIntent(intent);
        Log.d((String)"onNewIntent", (String)"set new intent");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_najva1237121793087);
        String notificationAction = null;
        String finalAddress = "";
        int notificationId = 0;
        String messageId = "";
        String clickType = null;
        int buttonId = -1;
        try {
            buttonId = this.getIntent().getExtras().getInt("button_id");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            clickType = this.getIntent().getExtras().getString("click_type");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            messageId = this.getIntent().getExtras().getString("message_id");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            notificationAction = this.getIntent().getStringExtra("onclick_action");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            finalAddress = this.getIntent().getExtras().getString("final_address");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            notificationId = this.getIntent().getExtras().getInt("notification_id");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList websiteInfo = this.getIntent().getExtras().getStringArrayList("website_info");
        Intent notificationIntent = null;
        assert (notificationAction != null);
        switch (notificationAction) {
            case "open-link": {
                try {
                    finalAddress = URLDecoder.decode(finalAddress, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String url = finalAddress;
                notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                notificationIntent.setFlags(0x24000000);
                this.startActivity(notificationIntent);
                this.finish();
                break;
            }
            case "open-app": {
                String packageName = this.getApplicationContext().getPackageName();
                Intent launchIntent = this.getApplicationContext().getPackageManager().getLaunchIntentForPackage(packageName);
                String className = launchIntent.getComponent().getClassName();
                Class<?> act = null;
                try {
                    act = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                notificationIntent = new Intent(this.getApplicationContext(), act);
                break;
            }
            case "open-activity": {
                Class<?> act = null;
                try {
                    act = Class.forName(finalAddress);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                notificationIntent = new Intent(this.getApplicationContext(), act);
                break;
            }
            case "open-call": {
                notificationIntent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + finalAddress)));
                break;
            }
            case "open-sms": {
                String content = "";
                try {
                    content = this.getIntent().getExtras().getString("notification_content");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("sms:" + finalAddress)));
                notificationIntent.putExtra("sms_body", content);
                break;
            }
            case "open-telegram-channel": {
                notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("tg://resolve?domain=" + finalAddress)));
                break;
            }
            case "join-telegram-channel": {
                notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)finalAddress));
            }
        }
        if (notificationIntent != null && clickType != null && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue())) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            assert (notificationManager != null);
            notificationManager.cancel(messageId, 0);
        }
        assert (notificationIntent != null);
        notificationIntent.setFlags(0x24000000);
        this.startActivity(notificationIntent);
        if (Network.isConnected((Context)this)) {
            if (clickType != null && clickType.equalsIgnoreCase(Parameter.ORIGINAL_CLICK_TYPE.getValue())) {
                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CLICK_LOG.getValue(), null, null, this.getClickParams((String)websiteInfo.get(1), (String)websiteInfo.get(0), notificationId), "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                    }
                });
            } else if (clickType != null && buttonId > 0 && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue())) {
                Log.d((String)"buttonClick", (String)"before request");
                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.BUTTON_CLICK_LOG.getValue(), null, null, this.getButtonClickLog((String)websiteInfo.get(1), (String)websiteInfo.get(0), notificationId, buttonId), "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                    }
                });
            }
        } else if (clickType != null && clickType.equalsIgnoreCase(Parameter.ORIGINAL_CLICK_TYPE.getValue())) {
            this.saveClickLog((String)websiteInfo.get(1), (String)websiteInfo.get(0), notificationId);
        } else if (clickType != null && clickType.equalsIgnoreCase(Parameter.BUTTON_CLICK_TYPE.getValue()) && buttonId > 0) {
            this.saveButtonClickLog((String)websiteInfo.get(1), (String)websiteInfo.get(0), notificationId, buttonId);
        }
        this.finish();
    }

    private HashMap<String, String> getClickParams(String apiKey, String websiteId, int notificationId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website_id", websiteId);
        params.put("api_key", apiKey);
        params.put("notification_id", String.valueOf(notificationId));
        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return params;
    }

    private HashMap<String, String> getButtonClickLog(String apiKey, String websiteId, int notificationId, int buttonId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website_id", websiteId);
        params.put("api_key", apiKey);
        params.put("notification_id", String.valueOf(notificationId));
        params.put("button_id", String.valueOf(buttonId));
        return params;
    }

    private String getCookie() {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(this.getApplicationContext());
        try {
            String line;
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveClickLog(String apiKey, String websiteId, int notificationId) {
        File path = this.getPath(this.getApplicationContext());
        try {
            File file = new File(path, Parameter.CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file, true);
            writer.write(apiKey + ":" + websiteId + ":" + String.valueOf(notificationId));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveButtonClickLog(String apiKey, String websiteId, int notifcationId, int buttonId) {
        File path = this.getPath(this.getApplicationContext());
        try {
            File file = new File(path, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file, true);
            writer.write(apiKey + ":" + websiteId + ":" + String.valueOf(notifcationId) + ":" + String.valueOf(buttonId));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context) {
        File path = new File(this.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }
}

