package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;
import android.widget.Toast;

import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;

import org.apache.http.HttpResponse;
import org.json.JSONException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class InstallPackageReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String packageName = intent.getData().getEncodedSchemeSpecificPart();
        PackageManager packageManager= context.getPackageManager();
        String appLabel = "";
        try {
            appLabel = (String) packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, PackageManager.GET_META_DATA));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        addPackageInfoRequest(context, packageName, appLabel);
    }

    private void addPackageInfoRequest(Context context, String packageName, String appLabel) {
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CHANGE_DEVICE_INFO.getValue(), null, null,
                getPackageInfoParams(packageName, appLabel), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                    }
                });
    }

    private HashMap<String, String> getPackageInfoParams(String packageName, String appLabel) {
        HashMap<String, String> params = new HashMap<>();

        String encodedAppLable = appLabel;
        try {
            encodedAppLable = URLEncoder.encode(encodedAppLable, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put("operation", "add");
        params.put("package_name", packageName);
        params.put("app_label", encodedAppLable);

        return params;
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

}
