package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;

import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;

import org.apache.http.HttpResponse;
import org.json.JSONException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ChangeSimcardReceiver extends BroadcastReceiver{
    @Override
    public void onReceive(Context context, Intent intent) {
        String newOperator = getSimOperatorName(context);
        if (!newOperator.equalsIgnoreCase(getLastSimcardOperator(context))){
            saveNewOperator(context);
            sendNewOperatorToServer(context);
        }
    }

    private String getSimOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    private String getLastSimcardOperator(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return "";
    }

    private void saveNewOperator(Context context) {
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write(getSimOperatorName(context));
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private void sendNewOperatorToServer(Context context) {
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null,
                getOperatorParams(getSimOperatorName(context)), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                    }
                });
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private HashMap<String, String> getOperatorParams(String operator) {
        HashMap<String, String> params = new HashMap<>();
        params.put("operator", operator);

        return params;
    }
}
