/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.najva.najvasdk.Utils.IBitmapResponse;
import com.najva.najvasdk.Utils.IResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class HttpHandleResponse {
    public static void sendRequest(final String method, final String host, final String url, final String username, final String password, final HashMap<String, String> params, final String contenType, final String cookie, final IResponse iResponse) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Object entity;
                String urlPath = url.replace(" ", "+");
                Log.d((String)"tagtag: urlPath: ", (String)urlPath);
                Log.d((String)"params in http handle", (String)String.valueOf(params == null));
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpGet httpGet = null;
                HttpPost httpPost = null;
                UsernamePasswordCredentials defaultcreds = null;
                if (username != null && password != null) {
                    defaultcreds = new UsernamePasswordCredentials(username, password);
                }
                if (method.equals("GET")) {
                    httpGet = new HttpGet(urlPath);
                    if (defaultcreds != null) {
                        httpGet.addHeader(BasicScheme.authenticate((Credentials)defaultcreds, (String)"UTF-8", (boolean)false));
                    }
                    httpGet.setHeader("Content-Type", "application/json");
                    if (cookie != null) {
                        httpGet.setHeader("Cookie", cookie);
                    }
                } else if (method.equals("POST")) {
                    httpPost = new HttpPost(urlPath);
                    if (contenType == "application/json") {
                        if (params != null) {
                            String bodyJson = "{";
                            for (String key : params.keySet()) {
                                bodyJson = bodyJson + "\"" + key + "\": \"" + (String)params.get(key) + "\"";
                                bodyJson = bodyJson + ", ";
                            }
                            if (bodyJson.length() > 1) {
                                bodyJson = bodyJson.substring(0, bodyJson.length() - 2);
                            }
                            bodyJson = bodyJson + "}";
                            Log.d((String)"json body", (String)bodyJson);
                            entity = null;
                            try {
                                entity = new StringEntity(bodyJson);
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            httpPost.setEntity((HttpEntity)entity);
                        }
                    } else if (contenType == "application/x-www-form-urlencoded" && params != null) {
                        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
                        for (String key : params.keySet()) {
                            pairs.add(new BasicNameValuePair(key, (String)params.get(key)));
                        }
                        try {
                            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    if (defaultcreds != null) {
                        httpPost.addHeader(BasicScheme.authenticate((Credentials)defaultcreds, (String)"UTF-8", (boolean)false));
                    }
                    if (cookie != null) {
                        httpPost.setHeader("Cookie", cookie);
                    }
                    httpPost.addHeader("content-type", contenType);
                }
                if (defaultcreds != null) {
                    httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, -1), (Credentials)defaultcreds);
                }
                try {
                    Header[] headers;
                    HttpResponse response = null;
                    if (method.equals("GET")) {
                        response = httpClient.execute((HttpUriRequest)httpGet);
                    } else if (method.equals("POST")) {
                        Log.d((String)"tagtag: in response: ", (String)String.valueOf(response));
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        Log.d((String)"tagtag response: ", (String)String.valueOf(response));
                    }
                    assert (response != null);
                    entity = response.getEntity().getContent();
                    BufferedReader bR = new BufferedReader(new InputStreamReader((InputStream)entity));
                    String line = "";
                    StringBuilder responseStrBuilder = new StringBuilder();
                    while ((line = bR.readLine()) != null) {
                        responseStrBuilder.append(line);
                    }
                    ((InputStream)entity).close();
                    for (Header header : headers = response.getAllHeaders()) {
                        System.out.println(" --> " + header.getName() + ":" + header.getValue());
                    }
                    System.out.println(response.getHeaders("Set-Cookie").length);
                    for (Header h : response.getHeaders("Set-Cookie")) {
                        System.out.println("cookie: " + h.getValue().subSequence(h.getValue().indexOf("=") + 1, h.getValue().indexOf(";") + 1));
                    }
                    iResponse.handleRequest(response, responseStrBuilder.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public static void getBitmapFromURL(final String src, final IBitmapResponse iBitmapResponse) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (src == null) {
                    iBitmapResponse.handleBitmapRequest(null);
                }
                try {
                    HttpGet httpRequest = new HttpGet(URI.create(src.toString()));
                    DefaultHttpClient httpclient = new DefaultHttpClient();
                    HttpResponse response = httpclient.execute((HttpUriRequest)httpRequest);
                    HttpEntity entity = response.getEntity();
                    BufferedHttpEntity bufHttpEntity = new BufferedHttpEntity(entity);
                    Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)bufHttpEntity.getContent());
                    httpRequest.abort();
                    iBitmapResponse.handleBitmapRequest(myBitmap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.d((String)"Exception", (String)e.toString());
                }
            }
        });
        thread.start();
    }
}

