/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.json.JSONException;

public class ChangeSimcardReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String newOperator = this.getSimOperatorName(context);
        System.out.println("newOperator: " + newOperator);
        System.out.println("lastOperator: " + this.getSimOperatorName(context));
        if (!newOperator.equalsIgnoreCase(this.getLastSimcardOperator(context))) {
            System.out.println("in change simcard if");
            this.saveNewOperator(context);
            this.sendNewOperatorToServer(context);
        }
    }

    private String getSimOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        assert (manager != null);
        return manager.getSimOperatorName();
    }

    private String getLastSimcardOperator(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void saveNewOperator(Context context) {
        File path = this.getPath(context);
        try {
            File file = new File(path, Parameter.OPERATOR_NAME_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write(this.getSimOperatorName(context));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private void sendNewOperatorToServer(Context context) {
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null, this.getOperatorParams(this.getSimOperatorName(context)), "application/x-www-form-urlencoded", this.getCookie(context), new IResponse(){

            @Override
            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                System.out.println("response operator-device: " + strResponse);
            }
        });
    }

    private String getCookie(Context context) {
        ArrayList<String> records = new ArrayList<String>();
        File path = this.getPath(context);
        try {
            String line;
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            if (records.size() > 0) {
                return (String)records.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HashMap<String, String> getOperatorParams(String operator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("operator", operator);
        return params;
    }
}

