/*
 * Decompiled with CFR 0.152.
 */
package com.najva.najvasdk.Class;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.FileSystem;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;

public class Najva {
    private static Najva najva;
    private String token;
    private String apiKey;
    private int websiteId;
    private int campaignId;
    private boolean location;
    private Context context;
    private FusedLocationProviderClient fusedLocationClient;

    public static void initialize(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        Najva.getInstance().init(context, campaignId, websiteId, apiKey, location);
    }

    public static Najva getInstance() {
        if (najva == null) {
            najva = new Najva();
        }
        return najva;
    }

    private void init(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        this.apiKey = apiKey;
        this.websiteId = websiteId;
        this.campaignId = campaignId;
        this.location = location;
        this.context = context;
        this.fusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)this.context);
        FirebaseOptions options = new FirebaseOptions.Builder().setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()).setApiKey(Parameter.FIREBASE_API_KEY.getValue()).setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()).build();
        try {
            FirebaseApp.getInstance((String)this.apiKey);
            System.out.println("in try firebase init");
        }
        catch (IllegalStateException e) {
            FirebaseApp.initializeApp((Context)context, (FirebaseOptions)options, (String)this.apiKey);
            System.out.println("in catch firebase init");
        }
        this.saveWebsiteInfo();
        if (this.location) {
            try {
                this.setLocationRequest();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.checkAppVersion();
        this.updateLastLogin();
    }

    public void updateSubscriber(String token) {
        this.token = token;
        try {
            this.addSubscriberToCampaign(this.context, this.getParams(), this.location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addSubscriberToCampaign(final Context context, HashMap<String, String> params, final boolean location) throws IOException {
        Log.d((String)"tagtag", (String)"before http request");
        if (this.isSubscribed()) {
            System.out.println("already subscribed!");
            return;
        }
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.ADD_SUBSCRIBER_URL.getValue(), null, null, params, "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

            @Override
            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                if (Najva.this.responseStatus(response) == 200) {
                    Najva.this.updateSubscriptionFile(context);
                    Najva.this.saveCookie(response);
                    System.out.println("response status is 200! and update file");
                }
                if (location && Najva.this.responseStatus(response) == 200) {
                    try {
                        Najva.this.setLocationRequest();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Log.d((String)"deviceInfo", (String)"before call method");
                Najva.this.createDeviceInfoRequest();
                Najva.this.saveSimOperator();
            }
        });
    }

    private void setLocationRequest() throws IOException {
        if (!this.isSubscribed()) {
            return;
        }
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)1);
        } else {
            if (!this.checkLocationStatus()) {
                return;
            }
            this.fusedLocationClient.getLastLocation().addOnSuccessListener((Activity)this.context, (OnSuccessListener)new OnSuccessListener<Location>(){

                public void onSuccess(Location currentLocation) {
                    if (currentLocation != null) {
                        Log.d((String)"location accuracy: ", (String)String.valueOf(currentLocation.getAccuracy()));
                        Log.d((String)"location latitude: ", (String)String.valueOf(currentLocation.getLatitude()));
                        Log.d((String)"location longitude: ", (String)String.valueOf(currentLocation.getLongitude()));
                        Log.d((String)"location altitude: ", (String)String.valueOf(currentLocation.getAltitude()));
                        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.SET_LOCATION_URL.getValue(), null, null, Najva.this.getLocationParams(currentLocation), "application/json", Najva.this.getCookie(), new IResponse(){

                            @Override
                            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                                Najva.this.saveCookie(response);
                                if (Najva.this.responseStatus(response) == 200) {
                                    Najva.this.saveLastLocationTime();
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void createDeviceInfoRequest() {
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CREATE_DEVICE_INFO.getValue(), null, null, this.getDeviceInfoParams(), "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

            @Override
            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                System.out.println("response device: " + strResponse);
            }
        });
    }

    private int responseStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token_id", this.token);
        params.put("api_key", this.apiKey);
        params.put("website_id", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));
        Log.d((String)"tagtag", (String)"now return params");
        return params;
    }

    private HashMap<String, String> getLocationParams(Location locationObject) {
        HashMap<String, String> params = new HashMap<String, String>();
        Log.d((String)"params input", (String)String.valueOf(locationObject == null));
        if (locationObject != null) {
            params.put("latitude", String.valueOf(locationObject.getLatitude()));
            params.put("longitude", String.valueOf(locationObject.getLongitude()));
            params.put("altitude", String.valueOf(locationObject.getAltitude()));
            params.put("accuracy", String.valueOf(locationObject.getAccuracy()));
        }
        return params;
    }

    private HashMap<String, String> getDeviceInfoParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sim_operator_name", this.getSimOperatorName());
        params.put("device_model", Najva.getDeviceModel());
        params.put("android_version", this.getAndroidVersion());
        String encodedPackageInfo = this.getPackageInfo();
        try {
            encodedPackageInfo = URLEncoder.encode(encodedPackageInfo, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        params.put("android_package_info", encodedPackageInfo);
        params.put("manufacturer", Build.MANUFACTURER);
        params.put("app_version", this.getAppVersion());
        return params;
    }

    private boolean isSubscribed() {
        String value = FileSystem.readFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
        return value != null && Integer.valueOf(value) == 1;
    }

    private void updateSubscriptionFile(Context context) {
        ArrayList<String> values = new ArrayList<String>();
        values.add("1");
        FileSystem.saveToFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue(), values);
    }

    private String getCookie() {
        return FileSystem.readFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
    }

    private void saveCookie(HttpResponse response) {
        if (response.getHeaders("Set-Cookie").length > 0) {
            for (Header h : response.getHeaders("Set-Cookie")) {
                if (!h.getValue().contains("najva_token")) continue;
                String cookie = "najva_token=" + h.getValue().substring(h.getValue().indexOf("=") + 1, h.getValue().indexOf(";") + 1);
                this.updateCookie(cookie);
            }
        }
    }

    private void updateCookie(String cookie) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(cookie);
        FileSystem.saveToFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue(), values);
    }

    private void saveLastLocationTime() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue(), values);
    }

    private boolean checkLocationStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(12L)).before(lastDate)) {
                return false;
            }
        }
        return true;
    }

    private void saveWebsiteInfo() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(this.websiteId));
        values.add(System.getProperty("line.separator"));
        values.add(this.apiKey);
        FileSystem.saveToFile(this.context, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue(), values);
    }

    private void saveSimOperator() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getSimOperatorName());
        FileSystem.saveToFile(this.context, Parameter.OPERATOR_NAME_FILE_NAME.getValue(), values);
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private static String getDeviceModel() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    private String getSimOperatorName() {
        TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
        assert (manager != null);
        return manager.getSimOperatorName();
    }

    private String getAndroidVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    private String getPackageInfo() {
        StringBuilder jsonResponse = new StringBuilder("[");
        PackageManager packageManager = this.context.getPackageManager();
        List installedApplications = packageManager.getInstalledApplications(128);
        for (ApplicationInfo appInfo : installedApplications) {
            jsonResponse.append("{\"package_name\": ").append("\"").append(appInfo.packageName).append("\"").append(", ").append("\"app_label\": ").append("\"").append(appInfo.loadLabel(packageManager)).append("\"").append("}, ");
        }
        if (jsonResponse.length() > 1) {
            jsonResponse = new StringBuilder(jsonResponse.substring(0, jsonResponse.length() - 2));
        }
        jsonResponse.append("]");
        return jsonResponse.toString();
    }

    private String getAppVersion() {
        String version = "";
        try {
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            version = pInfo.versionName;
            System.out.println(version == null);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    private void checkAppVersion() {
        String lastVersion = this.getLastAppVersionSaved();
        String currentVersion = this.getAppVersion();
        if (lastVersion == null) {
            this.saveLastAppVersion();
            Log.d((String)"app_version", (String)"saveLastAppVersion");
        } else if (!lastVersion.equalsIgnoreCase(currentVersion)) {
            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null, this.getAppVersionParams(currentVersion), "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

                @Override
                public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                    System.out.println("response device: " + strResponse);
                    if (Najva.this.responseStatus(response) == 200) {
                        Najva.this.saveLastAppVersion();
                        Log.d((String)"app_version", (String)"saveLastAppVersion");
                    }
                }
            });
        }
    }

    private void saveLastAppVersion() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getAppVersion());
        FileSystem.saveToFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue(), values);
    }

    private String getLastAppVersionSaved() {
        String val = FileSystem.readFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue());
        return val;
    }

    private HashMap<String, String> getAppVersionParams(String newVersion) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_version", newVersion);
        return params;
    }

    private void updateLastLogin() {
        if (!this.checkLastLoginTimeStatus()) {
            return;
        }
        HttpHandleResponse.sendRequest("GET", ApiInfo.HOST.getValue(), ApiInfo.API_CURRENT_USER.getValue(), null, null, this.getLastUpdateTimeParams(), "application/x-www-form-urlencoded", this.getCookie(), new IResponse(){

            @Override
            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                Najva.this.saveCookie(response);
                if (Najva.this.responseStatus(response) == 200) {
                    Najva.this.saveLastLoginTime();
                }
            }
        });
    }

    private HashMap<String, String> getLastUpdateTimeParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("update_time", "1");
        params.put("get_token", "1");
        params.put("api_key", this.apiKey);
        params.put("website", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));
        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            System.out.println("NAJVATOKEN: " + najvaToken);
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return params;
    }

    private void saveLastLoginTime() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue(), values);
    }

    private boolean checkLastLoginTimeStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24L)).before(lastDate) && lastDate.getDay() == new Date(System.currentTimeMillis()).getDay()) {
                System.out.println("does not new date and shouldn't update date time");
                return false;
            }
        }
        return true;
    }
}

