package com.najva.najvasdk.Service;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.RemoteInput;
import android.util.Log;
import android.widget.Toast;


import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.najvasdk.Activity.DialogActivity;
import com.najva.najvasdk.Activity.NajvaActivity;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Dialog.NotificationDialog;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IBitmapResponse;
import com.najva.najvasdk.R;
import com.najva.najvasdk.Utils.IconHandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

/**
 * Created by sina on 9/16/2018.
 */
public class NajvaMessagingService extends FirebaseMessagingService {

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
//        RemoteMessage.Notification notification = remoteMessage.getNotification();
        String messageId = remoteMessage.getMessageId();
        Log.d("message_id", remoteMessage.getMessageId());
        Map<String, String> data = remoteMessage.getData();
        ShowNotification(data, messageId);
    }

    private void ShowNotification(final Map<String, String> data, final String messageId) {
        Log.d("inShowNotification", "recieved notification");
        final String notificationId = data.get("notification_id");
        final String finalAddress = data.get("url");
        final String onClickAction = data.get("onclick_action");
        String notificationContent = data.get("notification_content");
        final String priority = data.get("priority");

        for (String s: data.keySet()){
            System.out.println(s + " : " + data.get(s));
        }

        if (notificationContent == null){
            notificationContent = "";
        }

        final PendingIntent pendingIntent = setNotificationAction(onClickAction, Integer.parseInt(notificationId), finalAddress, notificationContent, messageId, Parameter.ORIGINAL_CLICK_TYPE.getValue(), -1);

        final String finalNotificationContent = notificationContent;
        HttpHandleResponse.getBitmapFromURL(data.get("icon"), new IBitmapResponse() {
            @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
            @Override
            public void handleBitmapRequest(Bitmap icon_response) {
                final Notification.Builder notificationBuilder = new Notification.Builder(getApplicationContext());
                notificationBuilder
                        .setContentTitle(data.get("title"))
                        .setContentText(data.get("body"))
                        .setAutoCancel(true);

                if (priority != null){
                    if (priority.equalsIgnoreCase("High")){
                        notificationBuilder.setPriority(Notification.PRIORITY_HIGH);
                    }else if (priority.equalsIgnoreCase("Low")){
                        notificationBuilder.setPriority(Notification.PRIORITY_LOW);
                    }
                }

                if (pendingIntent != null){
                    notificationBuilder.setContentIntent(pendingIntent);
                    Log.d("add pending intent", "pending intent");
                }

                if (data.get("icon") != null){
                    notificationBuilder.setLargeIcon(icon_response);
                }

                if (data.get("light_up_screen") != null && data.get("light_up_screen").equalsIgnoreCase("true")) {
                    PowerManager pm = (PowerManager)getApplicationContext().getSystemService(Context.POWER_SERVICE);
                    boolean isScreenOn = pm.isScreenOn();
                    if(!isScreenOn)
                    {
                        PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK |PowerManager.ACQUIRE_CAUSES_WAKEUP |PowerManager.ON_AFTER_RELEASE,"MyLock");
                        wl.acquire(10000);
                        PowerManager.WakeLock wl_cpu = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,"MyCpuLock");

                        wl_cpu.acquire(10000);
                    }
                }

                if (data.get("btn1_enabled") != null && data.get("btn1_enabled").equalsIgnoreCase("true")){
                    String btn1Title = "";
                    String btn1Action = "close";
                    String btn1FinalAddress = "";
                    String btn1Content = "";
                    int btn1Icon = 0;
                    int btn1Id = 0;
                    if (data.get("btn1_title") != null){btn1Title = data.get("btn1_title");}
                    if (data.get("btn1_icon") != null) {
                        int iconCode = 0;
                        try {
                            iconCode = Integer.valueOf(data.get("btn1_icon"));
                        }catch (Exception e){}

                        btn1Icon = IconHandler.getNotificationButtonIcon(iconCode);
                    }

                    if (data.get("btn1_id") != null) {
                        Log.d("in btn1_id", "before");
                        btn1Id = Integer.valueOf(data.get("btn1_id"));
                        Log.d("in btn1_action", String.valueOf(btn1Id));
                    }

                    if (data.get("btn1_action") != null) {
                        btn1Action = data.get("btn1_action");
                        Log.d("in btn1_action", "after");
                    }

                    if (data.get("btn1_final_address") != null) {
                        btn1FinalAddress = data.get("btn1_final_address");
                    }

                    if (data.get("btn1_content") != null) {
                        btn1Content = data.get("btn1_content");
                    }

                    Log.d("in btn1", "before created!");
                    PendingIntent buttonPendingIntent = setNotificationAction(btn1Action, Integer.parseInt(notificationId), btn1FinalAddress, btn1Content, messageId, Parameter.BUTTON_CLICK_TYPE.getValue(), btn1Id);
                    notificationBuilder.addAction(btn1Icon, btn1Title, buttonPendingIntent);
                    Log.d("in btn1", "after create!");
                }

                if (data.get("btn2_enabled") != null && data.get("btn2_enabled").equalsIgnoreCase("true")){
                    String btn2Title = "";
                    String btn2Action = "close";
                    String btn2FinalAddress = "";
                    String btn2Content = "";
                    int btn2Icon = 0;
                    int btn2Id = 0;
                    if (data.get("btn2_title") != null){btn2Title = data.get("btn2_title");}
                    if (data.get("btn2_icon") != null) {
                        int iconCode = 0;
                        try {
                            iconCode = Integer.valueOf(data.get("btn2_icon"));
                        }catch (Exception e){}

                        btn2Icon = IconHandler.getNotificationButtonIcon(iconCode);
                    }

                    if (data.get("btn2_id") != null) {
                        btn2Id = Integer.valueOf(data.get("btn2_id"));
                    }

                    if (data.get("btn2_action") != null) {
                        btn2Action = data.get("btn2_action");
                    }

                    if (data.get("btn2_final_address") != null) {
                        btn2FinalAddress = data.get("btn2_final_address");
                    }

                    if (data.get("btn2_content") != null) {
                        btn2Content = data.get("btn2_content");
                    }

                    PendingIntent buttonPendingIntent = setNotificationAction(btn2Action, Integer.parseInt(notificationId), btn2FinalAddress, btn2Content, messageId, Parameter.BUTTON_CLICK_TYPE.getValue(), btn2Id);
                    notificationBuilder.addAction(btn2Icon, btn2Title, buttonPendingIntent);
                }

                if (data.get("image") != null) {
                    HttpHandleResponse.getBitmapFromURL(data.get("image"), new IBitmapResponse() {
                        @Override
                        public void handleBitmapRequest(Bitmap image_response) {
                            Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle()
                                    .bigPicture(image_response)
                                    .setBigContentTitle(data.get("title"))
                                    .setSummaryText(data.get("body"));
                            notificationBuilder.setStyle(bigPictureStyle);

                            notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                            notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                            notificationBuilder.setLights(Color.BLUE, 1000, 300);


//                            NotificationDialog notificationDialog = new NotificationDialog(getApplicationContext());
//                            notificationDialog.show();

                            NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                            assert notificationManager != null;
                            notificationManager.notify(messageId, 0, notificationBuilder.build());

//                            Intent dialogIntent = new Intent(getApplicationContext(), DialogActivity.class);
//                            dialogIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                            startActivity(dialogIntent);
                        }
                    });

                } else {
                    notificationBuilder.setSmallIcon(R.drawable.notif_icon);
                    notificationBuilder.setDefaults(Notification.DEFAULT_VIBRATE);
                    notificationBuilder.setLights(Color.BLUE, 1000, 300);



                    NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                    assert notificationManager != null;
                    notificationManager.notify(messageId, 0, notificationBuilder.build());

//                    Intent dialogIntent = new Intent(getApplicationContext(), DialogActivity.class);
//                    dialogIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                    startActivity(dialogIntent);
                }



            }
        });
    }

    @Override
    public void onNewToken(String token) {
        updateSubscriptionFile(getApplicationContext());

        System.out.println("befor najva.getInstance()");
        Najva.getInstance().updateSubscriber(token);
        System.out.println("after najva.getInstance()");
    }

    private void updateSubscriptionFile(Context context) {
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("0");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getWebsiteInfo(Context context){
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            for (String s: records){
                System.out.println(s);
            }

            if (records.size() < 2) {
                records.set(0, "0");
                records.set(1, null);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return records;

    }

    public File getPath(Context context){
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()){
            path.mkdir();
        }

        return path;
    }

    private PendingIntent setNotificationAction(String notificationAction, int notificationId, String finalAddress, String notificationContent, String messageId, String clickType, int button_id){

        Intent notificationIntent;

        Class<?> act = null;
        try {
            act = Class.forName("com.najva.najvasdk.Activity.NajvaActivity");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        notificationIntent = new Intent(getApplicationContext(), act);

        // firebase message_id for notification_id is unique
        notificationIntent.putExtra("message_id", messageId);
        notificationIntent.putExtra("onclick_action", notificationAction);
        notificationIntent.putExtra("final_address", finalAddress);
        notificationIntent.putExtra("notification_id", notificationId);
        notificationIntent.putExtra("website_info", getWebsiteInfo(getApplicationContext()));
        notificationIntent.putExtra("notification_content", notificationContent);
        // click on notification or on a button of notification?
        notificationIntent.putExtra("click_type", clickType);
        // button-id
        if (button_id > 0){
            notificationIntent.putExtra("button_id", button_id);
        }

        if (notificationIntent != null){
            // generate random integer for pending intent unique
            int dummyUniqueInt = new Random().nextInt(543254);
            PendingIntent pendingIntent = PendingIntent.getActivity(this, dummyUniqueInt, notificationIntent, PendingIntent.FLAG_CANCEL_CURRENT);
            return pendingIntent;
        }

        return null;

    }
}
