package com.najva.najvasdk.Receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.google.firebase.analytics.FirebaseAnalytics;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;
import com.najva.najvasdk.Utils.Network;

import org.apache.http.HttpResponse;
import org.json.JSONException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class NetworkReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (Network.isConnected(context)){
            sendClickLogs(context);
            sendButtonClickLog(context);
        }
    }

    private void sendButtonClickLog(Context context){
        ArrayList<String[]> logs = getClickLogs(context, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
        if (logs == null){
            return;
        }

        for (int i = 0; i < logs.size(); i++){
            String[] log = logs.get(i);
            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.BUTTON_CLICK_LOG.getValue(),
                    null, null, getButtonParameters(log), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
                        @Override
                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                            Log.d("request in broadcast", strResponse);
                        }
                    });
        }

        clearButtonClickLogs(context);
    }

    private void sendClickLogs(Context context){
        ArrayList<String[]> logs = getClickLogs(context, Parameter.CLICK_LOGS_FILE_NAME.getValue());
        if (logs == null){
            return;
        }

        for (int i = 0; i < logs.size(); i++){
            String[] log = logs.get(i);
            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CLICK_LOG.getValue(),
                    null, null, getParameters(context, log), "application/x-www-form-urlencoded", getCookie(context), new IResponse() {
                        @Override
                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {

                        }
                    });
        }

        clearClickLogs(context);

    }

    private HashMap<String, String> getParameters(Context context, String[] log){
        HashMap<String, String> params = new HashMap<>();

        Log.d("log.lenght count", String.valueOf(log.length));
        if (log.length != 3){
            return params;
        }

        params.put("api_key", log[0]);
        params.put("website_id", log[1]);
        params.put("notification_id", log[2]);

        String najvaToken = this.getCookie(context);
        if (najvaToken != null) {
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            } catch (Exception ignored) {}
        }

        return params;
    }

    private HashMap<String, String> getButtonParameters(String[] log) {
        HashMap<String, String> params = new HashMap<>();

        if (log.length != 4){
            return params;
        }

        params.put("api_key", log[0]);
        params.put("website_id", log[1]);
        params.put("notification_id", log[2]);
        params.put("button_id", log[3]);

        return params;
    }

    private ArrayList<String[]> getClickLogs(Context context, String fileName){
        ArrayList<String[]> clickLogs = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, fileName);
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                String[] log = line.split(":");
                clickLogs.add(log);
            }
            reader.close();

            if (clickLogs.size() > 0) {
                return clickLogs;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private String getCookie(Context context){
        ArrayList<String> records = new ArrayList<>();
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
            if (!file.exists()) {
                file.createNewFile();
            }

            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();

            if (records.size() > 0) {
                return records.get(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private void clearClickLogs(Context context){
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void clearButtonClickLogs(Context context){
        File path = getPath(context);

        try {
            File file = new File(path, Parameter.BUTTON_CLICK_LOGS_FILE_NAME.getValue());
            FileWriter writer = new FileWriter(file);
            writer.write("");
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getPath(Context context){
        File path = new File(context.getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }
}
