package com.najva.najvasdk.Class;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.najva.najvasdk.Model.ApiInfo;
import com.najva.najvasdk.Model.Parameter;
import com.najva.najvasdk.Utils.FileSystem;
import com.najva.najvasdk.Utils.HttpHandleResponse;
import com.najva.najvasdk.Utils.IResponse;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by sina on 9/19/2018.
 */
public class Najva {
    private static Najva najva;
    private String token;
    private String apiKey;
    private int websiteId;
    private int campaignId;
    private boolean location;
    private Context context;
    private FusedLocationProviderClient fusedLocationClient;


    public static void initialize(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        getInstance().init(context, campaignId, websiteId, apiKey, location);
    }

    public static Najva getInstance() {
        if (najva == null) {
            najva = new Najva();
        }
        return najva;
    }

    private void init(Context context, int campaignId, int websiteId, String apiKey, boolean location) {
        this.apiKey = apiKey;
        this.websiteId = websiteId;
        this.campaignId = campaignId;
        this.location = location;
        this.context = context;
        this.fusedLocationClient = LocationServices.getFusedLocationProviderClient(this.context);

        FirebaseOptions options = new FirebaseOptions.Builder()
                .setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()) // Required for Analytics.
                .setApiKey(Parameter.FIREBASE_API_KEY.getValue()) // Required for Auth.
                .setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()) // Required for RTDB.
                .build();

        try {
            FirebaseApp.getInstance(this.apiKey);
            System.out.println("in try firebase init");
        } catch (IllegalStateException e) {
            // Initialize with api_key app.
            FirebaseApp.initializeApp(context /* Context */, options, this.apiKey);
            System.out.println("in catch firebase init");
        }


        // save website_id and api_key in file
        saveWebsiteInfo();

        if (this.location) {
            try {
                this.setLocationRequest();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        // check app-version every day
        checkAppVersion();

        // update last-login
        updateLastLogin();
    }

    public void updateSubscriber(String token) {
        this.token = token;

        try {
            addSubscriberToCampaign(context, getParams(), location);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addSubscriberToCampaign(final Context context, HashMap<String, String> params, final boolean location) throws IOException {
        Log.d("tagtag", "before http request");

        if (isSubscribed()) {
            System.out.println("already subscribed!");
            return;
        }

        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(),
                ApiInfo.ADD_SUBSCRIBER_URL.getValue(), null, null,
                params, "application/x-www-form-urlencoded", getCookie(), new IResponse() {
                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                        if (responseStatus(response) == 200) {
                            updateSubscriptionFile(context);
                            saveCookie(response);
                            System.out.println("response status is 200! and update file");
                        }


                        if (location && responseStatus(response) == 200) {
                            try {
                                setLocationRequest();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                        Log.d("deviceInfo", "before call method");
                        createDeviceInfoRequest();
                        saveSimOperator();

                    }
                });

    }

    private void setLocationRequest() throws IOException {
        if (!isSubscribed()) {
            return;
        }

        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {

            ActivityCompat.requestPermissions((Activity) context, new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 1);

        } else {

            if (!checkLocationStatus()) {
                return;
            }

            this.fusedLocationClient.getLastLocation()
                    .addOnSuccessListener((Activity) this.context, new OnSuccessListener<Location>() {
                        @Override
                        public void onSuccess(Location currentLocation) {
                            // Got last known location. In some rare situations this can be null.
                            if (currentLocation != null) {
                                Log.d("location accuracy: ", String.valueOf(currentLocation.getAccuracy()));
                                Log.d("location latitude: ", String.valueOf(currentLocation.getLatitude()));
                                Log.d("location longitude: ", String.valueOf(currentLocation.getLongitude()));
                                Log.d("location altitude: ", String.valueOf(currentLocation.getAltitude()));

                                HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.SET_LOCATION_URL.getValue(),
                                        null, null, getLocationParams(currentLocation), "application/json", getCookie(), new IResponse() {
                                            @Override
                                            public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                                                saveCookie(response);
                                                if (responseStatus(response) == 200) {
                                                    saveLastLocationTime();
                                                }
                                            }
                                        });
                            }
                        }
                    });
        }
    }

    private void createDeviceInfoRequest() {
        HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.CREATE_DEVICE_INFO.getValue(), null, null,
                getDeviceInfoParams(), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                        System.out.println("response device: " + strResponse);
                    }
                });
    }


    private int responseStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }


    private HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("token_id", this.token);
        params.put("api_key", this.apiKey);
        params.put("website_id", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));

        Log.d("tagtag", "now return params");
        return params;
    }

    private HashMap<String, String> getLocationParams(Location locationObject) {
        HashMap<String, String> params = new HashMap<>();

        Log.d("params input", String.valueOf(locationObject == null));
        if (locationObject != null) {
            params.put("latitude", String.valueOf(locationObject.getLatitude()));
            params.put("longitude", String.valueOf(locationObject.getLongitude()));
            params.put("altitude", String.valueOf(locationObject.getAltitude()));
            params.put("accuracy", String.valueOf(locationObject.getAccuracy()));
        }

        return params;
    }

    private HashMap<String, String> getDeviceInfoParams(){
        HashMap<String, String> params = new HashMap<>();

        params.put("sim_operator_name", getSimOperatorName());
        params.put("device_model", getDeviceModel());
        params.put("android_version", getAndroidVersion());

        String encodedPackageInfo = getPackageInfo();
        try {
            encodedPackageInfo = URLEncoder.encode(encodedPackageInfo, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put("android_package_info", encodedPackageInfo);
        params.put("manufacturer", Build.MANUFACTURER);
        params.put("app_version", getAppVersion());

        return params;
    }

    private boolean isSubscribed() {
        String value = FileSystem.readFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());

        return value != null && Integer.valueOf(value) == 1;

        //        ArrayList<String> records = new ArrayList<>();
//
//        File path = getPath(context);
//
//        try {
//            File file = new File(path, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue());
//            if (!file.exists()) {
//                file.createNewFile();
//                System.out.println("file created!");
//            }
//
//            BufferedReader reader = new BufferedReader(new FileReader(file));
//            String line;
//            while ((line = reader.readLine()) != null) {
//                records.add(line);
//            }
//            reader.close();
//
//            if (records.size() > 0) {
//                if (Integer.valueOf(records.get(0)) == 1) {
//                    return true;
//                }
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//
//        return false;
    }

    private void updateSubscriptionFile(Context context) {
        ArrayList<String> values = new ArrayList<>();
        values.add("1");
        FileSystem.saveToFile(this.context, Parameter.SUBSCRIPTION_STATUS_FILE_NAME.getValue(), values);
    }

    private String getCookie() {
        return FileSystem.readFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
//        ArrayList<String> records = new ArrayList<>();
//        File path = getPath(context);
//
//        try {
//            File file = new File(path, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
//            if (!file.exists()) {
//                file.createNewFile();
//            }
//
//            BufferedReader reader = new BufferedReader(new FileReader(file));
//            String line;
//            while ((line = reader.readLine()) != null) {
//                records.add(line);
//            }
//            reader.close();
//
//            if (records.size() > 0) {
//                return records.get(0);
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//
//        return null;
    }

    private void saveCookie(HttpResponse response) {
        if (response.getHeaders("Set-Cookie").length > 0) {
            for (Header h : response.getHeaders("Set-Cookie")) {
                if (h.getValue().contains("najva_token")) {
                    String cookie = "najva_token=" + h.getValue().substring(h.getValue().indexOf("=") + 1, h.getValue().indexOf(";") + 1);
                    updateCookie(cookie);
                }
            }
        }
    }

    private void updateCookie(String cookie) {
        ArrayList<String> values = new ArrayList<>();
        values.add(cookie);
        FileSystem.saveToFile(this.context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue(), values);
    }

    private void saveLastLocationTime() {
        ArrayList<String> values = new ArrayList<>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue(), values);
    }

    private boolean checkLocationStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(12)).before(lastDate)) {
                return false;
            }
        }

        return true;
//        ArrayList<String> records = new ArrayList<>();
//        File path = getPath(context);
//
//        try {
//            File file = new File(path, Parameter.LAST_LOCATION_TIME_FILE_NAME.getValue());
//            if (!file.exists()) {
//                file.createNewFile();
//            }
//
//            BufferedReader reader = new BufferedReader(new FileReader(file));
//            String line;
//            while ((line = reader.readLine()) != null) {
//                records.add(line);
//            }
//            reader.close();
//
//            if (records.size() > 0) {
//                Date lastDate = new Date(records.get(0));
//                if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(12)).before(lastDate)) {
//                    return false;
//                }
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//
//        return true;
    }

    private void saveWebsiteInfo() {
        ArrayList<String> values = new ArrayList<>();
        values.add(String.valueOf(this.websiteId));
        values.add(System.getProperty("line.separator"));
        values.add(this.apiKey);

        FileSystem.saveToFile(this.context, Parameter.WEBSITE_API_KEY_INFO_FILE_NAME.getValue(), values);
    }

    private void saveSimOperator() {
        ArrayList<String> values = new ArrayList<>();
        values.add(getSimOperatorName());
        FileSystem.saveToFile(this.context, Parameter.OPERATOR_NAME_FILE_NAME.getValue(), values);
    }

    private File getPath(Context context) {
        File path = new File(context.getApplicationContext().getFilesDir(), "fileDir");
        if (!path.exists()) {
            path.mkdir();
        }
        return path;
    }

    private static String getDeviceModel() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    private String getSimOperatorName() {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    private String getAndroidVersion(){
        return String.valueOf(Build.VERSION.RELEASE);
    }

    private String getPackageInfo(){
        StringBuilder jsonResponse = new StringBuilder("[");
        PackageManager packageManager = context.getPackageManager();
        List<ApplicationInfo> installedApplications =
                packageManager.getInstalledApplications(PackageManager.GET_META_DATA);

        for (ApplicationInfo appInfo : installedApplications) {
            jsonResponse.append("{\"package_name\": ").append("\"").append(appInfo.packageName).append("\"").append(", ").append("\"app_label\": ").append("\"").append(appInfo.loadLabel(packageManager)).append("\"").append("}, ");
        }
        if (jsonResponse.length() > 1){
            jsonResponse = new StringBuilder(jsonResponse.substring(0, jsonResponse.length() - 2));
        }
        jsonResponse.append("]");

        return jsonResponse.toString();

    }

    private String getAppVersion() {
        String version = "";
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            version = pInfo.versionName;
            System.out.println(version == null);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }


    private void checkAppVersion() {
        String lastVersion = getLastAppVersionSaved();
        String currentVersion = getAppVersion();
        if (lastVersion == null) {
            saveLastAppVersion();
            Log.d("app_version", "saveLastAppVersion");

        }else if (!lastVersion.equalsIgnoreCase(currentVersion)) {

            HttpHandleResponse.sendRequest("POST", ApiInfo.HOST.getValue(), ApiInfo.UPDATE_OPERATOR.getValue(), null, null,
                    getAppVersionParams(currentVersion), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
                        @Override
                        public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                            System.out.println("response device: " + strResponse);
                            if (responseStatus(response) == 200){
                                saveLastAppVersion();
                                Log.d("app_version", "saveLastAppVersion");
                            }
                        }
                    });
        }
    }

    private void saveLastAppVersion() {
        ArrayList<String> values = new ArrayList<>();
        values.add(getAppVersion());
        FileSystem.saveToFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue(), values);
    }

    private String getLastAppVersionSaved() {
        String val = FileSystem.readFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue());
        return val;
    }

    private HashMap<String, String> getAppVersionParams(String newVersion) {
        HashMap<String, String> params = new HashMap<>();
        params.put("app_version", newVersion);
        return params;
    }

    private void updateLastLogin() {
        if (!checkLastLoginTimeStatus()) {
            return;
        }


        HttpHandleResponse.sendRequest("GET", ApiInfo.HOST.getValue(), ApiInfo.API_CURRENT_USER.getValue(),
                null, null, getLastUpdateTimeParams(), "application/x-www-form-urlencoded", getCookie(), new IResponse() {
                    @Override
                    public void handleRequest(HttpResponse response, String strResponse) throws JSONException {
                        saveCookie(response);
                        if (responseStatus(response) == 200) {
                            saveLastLoginTime();
                        }
                    }
                });


    }


    private HashMap<String, String> getLastUpdateTimeParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("update_time", "1");
        params.put("get_token", "1");
        params.put("api_key", this.apiKey);
        params.put("website", String.valueOf(this.websiteId));
        params.put("topic", String.valueOf(this.campaignId));

        String najvaToken = this.getCookie();
        if (najvaToken != null) {
            System.out.println("NAJVATOKEN: " + najvaToken);
            try {
                najvaToken = najvaToken.substring(12, najvaToken.length() - 1);
                params.put("najva_token", najvaToken);
            }catch (Exception ignored) {}
        }

        return params;
    }

    private void saveLastLoginTime() {
        ArrayList<String> values = new ArrayList<>();
        values.add(String.valueOf(new Date(System.currentTimeMillis())));
        FileSystem.saveToFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue(), values);
    }

    private boolean checkLastLoginTimeStatus() {
        String value = FileSystem.readFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue());
        if (value != null) {
            Date lastDate = new Date(value);
            if (new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24)).before(lastDate) && lastDate.getDay() == new Date(System.currentTimeMillis()).getDay()) {
                System.out.println("does not new date and shouldn't update date time");
                return false;
            }
        }

        return true;
    }
}