/*
 * Decompiled with CFR 0.152.
 */
package com.nabto.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.util.Log;
import com.nabto.api.NabtoAssetManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NabtoAndroidAssetManager
implements NabtoAssetManager {
    private Context context;
    private File nabtoHomeDirectory;
    private File nabtoResourceDirectory;
    private File nabtoNativeLibraryDirectory;

    public NabtoAndroidAssetManager(Context context) {
        this.context = context;
        ApplicationInfo info = context.getApplicationInfo();
        this.nabtoHomeDirectory = new File(context.getFilesDir(), "nabto");
        this.nabtoResourceDirectory = new File(context.getFilesDir(), "share/nabto");
        this.nabtoNativeLibraryDirectory = new File(info.nativeLibraryDir);
        Log.d((String)this.getClass().getSimpleName(), (String)("Native lib dir: " + this.getNabtoNativeLibraryDirectory()));
        Log.d((String)this.getClass().getSimpleName(), (String)("App resource dir: " + this.getNabtoResourceDirectory()));
        Log.d((String)this.getClass().getSimpleName(), (String)("App dir: " + this.getNabtoHomeDirectory()));
        this.copyDirContentsToLocation(context.getAssets(), "share", new File(context.getFilesDir() + "/share"), false);
    }

    @Override
    public String getNabtoHomeDirectory() {
        return this.nabtoHomeDirectory.getAbsolutePath();
    }

    @Override
    public String getNabtoResourceDirectory() {
        return this.nabtoResourceDirectory.getAbsolutePath();
    }

    String getNabtoNativeLibraryDirectory() {
        return this.nabtoNativeLibraryDirectory.getAbsolutePath();
    }

    private void copyDirContentsToLocation(AssetManager manager, String fileToCopy, File fileLocation, boolean overwrite) {
        try {
            String[] filesInDir = manager.list(fileToCopy);
            if (filesInDir.length == 0) {
                this.copyFromAssets(manager, fileToCopy, fileLocation, overwrite);
            } else {
                for (String fileInDir : filesInDir) {
                    this.copyDirContentsToLocation(manager, fileToCopy + "/" + fileInDir, new File(fileLocation + "/" + fileInDir), overwrite);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not get assets from directory " + fileToCopy, e);
        }
    }

    private void copyFromAssets(AssetManager manager, String asset, File fileLocation, boolean overwrite) {
        BufferedInputStream inStream;
        if (fileLocation.exists() && !overwrite) {
            return;
        }
        if (!fileLocation.getParentFile().exists() && !fileLocation.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Could not create directory: " + fileLocation.getParentFile().getPath());
        }
        Log.d((String)this.getClass().getSimpleName(), (String)("Writing asset file: " + asset + " to " + fileLocation.getAbsolutePath()));
        try {
            inStream = new BufferedInputStream(manager.open(asset, 2));
        }
        catch (IOException e) {
            Log.w((String)this.getClass().getSimpleName(), (String)("Could not read asset file: " + asset));
            return;
        }
        try {
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(fileLocation));
            byte[] buffer = new byte[10240];
            int length = 0;
            while ((length = ((InputStream)inStream).read(buffer)) >= 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((OutputStream)outStream).close();
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write file to " + fileLocation, e);
        }
    }
}

