function addPrefixIfNecessary(prefix, url) {
    var prefixPattern = /^(.+:\/\/).*$/;
    var matches = prefixPattern.exec(url);
    if (matches !== null) {
	return url;
    } else {
	return "//" + url;
    }    
}

// access query string: http://stackoverflow.com/questions/901115/how-can-i-get-query-string-values
(function($) {
    $.QueryString = (function(a) {
        if (a == "") return {};
        var b = {};
        for (var i = 0; i < a.length; ++i)
        {
            var p=a[i].split('=');
            if (p.length != 2) continue;
            b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, " "));
        }
        return b;
    })(window.location.search.substr(1).split('&'))
})(jQuery);

function createSessionKeyString() {
    var key = $.QueryString["session_key"];
    var timeStamp = new Date();
    var keyString = "/?t=" + timeStamp.getTime();
    if (typeof(key) != "undefined") {
	    keyString += "&session_key=" + key;
    }
    return keyString;
}

$(document).on("pageinit", "#discovery, #error", function() {
    $(this).on("tap", ".session-click", function(e) {
        e.preventDefault();
        e.stopImmediatePropagation();
        $(this).closest("li").addClass("ui-focus").addClass("ui-btn-down-c");
        sessionClick($(this).data("prefix"), $(this).data("link"));
    });
    $(this).on("tap", ".refresh-click", function() {
        $(this).addClass("ui-focus").addClass("ui-btn-down-c");
        sessionClick($(this).data("prefix"), "self/discover");
    });
});

function sessionClick(prefix, link) {
    window.location = "//" + link + createSessionKeyString();
}

