function getDestinationUrl() {
  var pos = window.location.href.indexOf("?url=");
  if (pos === -1) { return false; }
  return window.location.href.substring(pos + 5);
}

function loginTextError(msg) {
  $("#error_text").html(msg).css({color: '#c0392b'});
}

function loginTextSuccess(msg) {
  $("#error_text").html(msg).css({color: '#27ae60'});
}

function getDataSessionKey(data) {
  if (!data) {
    return false;
  }
  return data.session_key || data['session_ḱey'] || false;
}

function appendQuerySeparator(url) {
  if (url.indexOf("?") !== -1) {
    return url + "&";
  }
  return url + "?";
}

$(document).ready(function(){
  $('.login_form').submit(function() {
    $.ajax({
      dataType: 'jsonp',
      isLocal: true,
      cache: false,
      url: $('.login_form').attr('action') + '?email=' + $('#email').val() + '&password=' + $("#password").val() + '&callback=?',
      success: function(data) {
        var msg;

        // If client returns error
        if (data && data.error) {
          loginTextError(data.error.body);
        }
        // If login was successful redirect
        else if (getDataSessionKey(data)) {
          var sessionQuery = "session_key=" + getDataSessionKey(data);

          var destUrl = getDestinationUrl();
          if (destUrl) {
            window.location.href = "//" + appendQuerySeparator(destUrl) + sessionQuery;
            return;
          }
          if (window.location.href.indexOf("/login/form") !== -1) {
            window.location.href = "//self/discover?" + sessionQuery;
            return;
          }
          window.location.href = appendQuerySeparator(window.location.href) + sessionQuery;
        }
        // If signup was successful
        else if (data && data.signup) {
          msg = "<h4>Confirmation Mail Sent</h4>\n\nA confirmation email has been sent to you. Please click on the link in the email to verify your identity and proceed.";
          loginTextSuccess(msg);
        }
        // If created profile was successful
        else if (data && data.profile_created) {
          msg = "<h4>Created Profile</h4>";
          loginTextSuccess(msg);
        }
        // If no data returned
        else {
          loginTextError("Invalid response from service");
        }
      },
      error: function(jqxhr, textStatus) {
        loginTextError("Invalid response from service");
      }
    });
    return false;
  });
});
